package com.bxm.component.office.excel.export;

import com.bxm.component.office.excel.export.setting.ExportSetting;
import com.bxm.component.office.excel.export.themes.ExcelThemesManage;
import com.bxm.component.office.excel.format.CellValueManage;

import java.io.File;
import java.io.OutputStream;

/**
 * 功能说明：<br/>
 * Excel导出接口
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月1日<br/>
 */
public interface ExcelExporter {

    ExcelThemesManage getThemesManage();

    /**
     * 注入样式管理器
     * @param themesManage 样式管理器
     */
    void setThemesManage(ExcelThemesManage themesManage);

    CellValueManage getCellValueManage();

    /**
     * 注入excel单元格值处理转换器管理类
     * @param cellValueManage 值处理转换器管理类
     */
    void setCellValueManage(CellValueManage cellValueManage);

    /**
     * 执行文件导出操作
     * @param excelFile 导出文件
     * @param setting   文件导出配置
     */
    void export(File excelFile, ExportSetting setting);

    /**
     * 执行文件导出操作，将导出文件写入到文件流中
     * @param excelFileStream 导出文件输出流
     * @param setting         文件导出配置
     */
    void export(OutputStream excelFileStream, ExportSetting setting);

}
