package com.bxm.component.office.excel.parse.setting;

import com.bxm.component.office.excel.format.DefaultValue;
import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 功能说明：<br/>
 * Excel解析的头文件
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年4月22日<br/>
 */
public class ParseHeader {

    /**
     * 列号，获取对应列中的数据设置到属性中
     */
    private int colIndex;

    /**
     * sheet表头标题，获取对应表头标题中的数据设置到属性中
     */
    private String title;

    /**
     * 属性名，返回对象中的属性
     */
    private String field;

    /**
     * 列类型，用于对单元格的数据进行精准处理
     */
    private CellTypeEnum cellType = CellTypeEnum.STRING;

    /**
     * 解析需要的扩展参数
     */
    private Map<String, Object> expend;

    /**
     * Excel解析的单元格不存在值时，或请求的单元格不存在时，将调用此接口获取值
     */
    private DefaultValue<?> defaultValue;

    public ParseHeader() {
        super();
    }

    public ParseHeader(String title, String field) {
        super();
        this.title = title;
        this.field = field;
    }

    public ParseHeader(int colIndex, String field) {
        super();
        this.colIndex = colIndex;
        this.field = field;
    }

    public ParseHeader(String title, String field, CellTypeEnum cellType) {
        super();
        this.title = title;
        this.field = field;
        this.cellType = cellType;
    }

    public ParseHeader(int colIndex, String field, CellTypeEnum cellType) {
        super();
        this.colIndex = colIndex;
        this.field = field;
        this.cellType = cellType;
    }

    public ParseHeader(int colIndex, String title, String field, CellTypeEnum cellType) {
        super();
        this.colIndex = colIndex;
        this.title = title;
        this.field = field;
        this.cellType = cellType;
    }

    public DefaultValue<?> getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(DefaultValue<?> defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ParseHeader addExpend(String key, Object value) {
        if (null == expend) {
            expend = Maps.newHashMap();
        }
        expend.put(key, value);
        return this;
    }

    public Map<String, Object> getExpend() {
        return expend;
    }

    public void setExpend(Map<String, Object> expend) {
        this.expend = expend;
    }

    public int getColIndex() {
        return colIndex;
    }

    public ParseHeader setColIndex(int colIndex) {
        this.colIndex = colIndex;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public ParseHeader setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getField() {
        return field;
    }

    public ParseHeader setField(String field) {
        this.field = field;
        return this;
    }

    public CellTypeEnum getCellType() {
        return cellType;
    }

    public ParseHeader setCellType(CellTypeEnum cellType) {
        this.cellType = cellType;
        return this;
    }

}
