package com.bxm.component.office.excel.parse.setting;

import java.util.List;

import com.google.common.collect.Lists;

/**
 * 功能说明：<br/>
 * Excel文件解析设置参数类
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年4月22日<br/>
 */
public class ParseSetting {
    /**
     * 表头行,第一行下标为0。eg：如指定为2，将第三行作为表头进行解析并跳过前两行
     */
    private int headerRow = 0;

    /**
     * 起始读取行
    private int startRow = 0;
     */

    /**
     * 读取记录数量
    private int readRowNum = 2000;
     */

    /**
     * 头部信息取值模式，false表示根据列号进行取值，true表示根据列标题进行取值
     */
    private boolean headerModel = true;

    private Class<?> entityClasz;

    /**
     * 解析的头部信息设置
     */
    private List<ParseHeader> heads;

    public Class<?> getEntityClasz() {
        return entityClasz;
    }

    public ParseSetting setEntityClasz(Class<?> clasz) {
        this.entityClasz = clasz;
        return this;
    }

    public boolean isHeaderModel() {
        return headerModel;
    }

    public ParseSetting setHeaderModel(boolean headerModel) {
        this.headerModel = headerModel;
        return this;
    }

    public ParseSetting addHead(ParseHeader header){
        if(null == heads){
            heads = Lists.newArrayList();
        }
        heads.add(header);
        return this;
    }
    public int getHeaderRow() {
        return headerRow;
    }

    public ParseSetting setHeaderRow(int headerRow) {
        this.headerRow = headerRow;
        return this;
    }

    public List<ParseHeader> getHeads() {
        return heads;
    }

    public ParseSetting setHeads(List<ParseHeader> heads) {
        this.heads = heads;
        return this;
    }
}
