/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.office.excel.export.impl;

import com.bxm.component.office.excel.export.ExcelExporter;
import com.bxm.component.office.excel.export.setting.ExcelSheet;
import com.bxm.component.office.excel.export.setting.ExportSetting;
import com.bxm.component.office.excel.export.setting.SheetHeader;
import com.bxm.component.office.excel.export.themes.ExcelThemesManage;
import com.bxm.component.office.excel.format.CellValueConvertContext;
import com.bxm.component.office.excel.format.CellValueManage;
import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.bxm.component.office.exception.ExportException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractExcelExport
implements ExcelExporter {
    protected Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected ExcelThemesManage themesManage;
    protected CellValueManage cellValueManage;
    protected HSSFWorkbook workbook;
    protected HSSFSheet currentSheet = null;
    protected HSSFRow currentRow = null;
    protected HSSFCell currentCell = null;
    protected ExportSetting setting;
    protected File excelFile;
    protected OutputStream excelFileOutputStream;
    protected int currentRowNum = 0;
    protected int currentColNum = 0;
    private CellStyle titleCellStyle;
    private CellStyle headCellStyle;
    private CellStyle contentCellStyle;
    private boolean isNotFirstRow = false;
    private Map<Integer, Map<Integer, Integer>> rowAffect = new HashMap<Integer, Map<Integer, Integer>>();

    @Override
    public void export(OutputStream excelFileStream, ExportSetting setting) {
        this.excelFileOutputStream = excelFileStream;
        this.setting = setting;
        this.commonExport();
    }

    private void commonExport() {
        if (this.assertExportSetting()) {
            this.LOGGER.error("excel\u5bfc\u51fa\u6240\u9700\u53c2\u6570\u4e0d\u5168");
            return;
        }
        this.getContext().addExtend("EXPORT_SETTING", this.setting);
        try {
            this.createWorkbook();
            this.execExport();
            this.write();
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExportException(e);
        }
    }

    @Override
    public void export(File excelFile, ExportSetting setting) {
        this.excelFile = excelFile;
        this.setting = setting;
        this.commonExport();
    }

    private boolean assertExportSetting() {
        if (this.setting == null) {
            this.LOGGER.warn("ExportSetting\u5e94\u4e3a\u5fc5\u987b\u53c2\u6570\uff0c\u4e3a\u4e86\u517c\u5bb9\u8001\u7248\u672c\u4ee3\u7801\u5141\u8bb8\u4e3anull\uff0c\u6b64\u5904\u53ef\u80fd\u4f1a\u51fa\u73b0\u6f5c\u5728\u9519\u8bef");
            return false;
        }
        if (CollectionUtils.isEmpty(this.setting.getSheets())) {
            this.LOGGER.error("ExportSetting\u4e2d\u672a\u914d\u7f6eExcelSheet");
            return true;
        }
        for (ExcelSheet excelSheet : this.setting.getSheets()) {
            if (!CollectionUtils.isEmpty(excelSheet.getHeaders()) || excelSheet.hasExtendData()) continue;
            this.LOGGER.error("ExcelSheet\u4e2d\u65e2\u6ca1\u6709\u914d\u7f6eSheetHeader\uff0c\u4e5f\u6ca1\u6709\u914d\u7f6e\u6269\u5c55\u6570\u636eaddExtendData");
            return true;
        }
        return this.assertSetting();
    }

    protected abstract void execExport();

    protected CellValueConvertContext getContext() {
        return this.cellValueManage.getContext();
    }

    protected boolean assertFile(File excelFile) {
        boolean result;
        boolean bl = result = null == excelFile;
        if (result) {
            this.LOGGER.error("\u5bfc\u51faExcel\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u5bfc\u51fa\u6587\u4ef6");
        }
        return result;
    }

    protected boolean assertSetting() {
        return false;
    }

    protected void createWorkbook() {
        this.workbook = new HSSFWorkbook();
        this.getContext().setWorkbook((Workbook)this.workbook);
        this.themesManage.init(this.workbook);
        this.initStyle();
    }

    protected void write() throws IOException {
        if (this.excelFileOutputStream != null) {
            this.workbook.write(this.excelFileOutputStream);
            this.excelFileOutputStream.close();
            return;
        }
        if (this.excelFile != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.workbook.write((OutputStream)os);
            byte[] fileContent = os.toByteArray();
            FileUtils.writeByteArrayToFile((File)this.excelFile, (byte[])fileContent);
            os.close();
        }
    }

    private void initStyle() {
        this.titleCellStyle = this.themesManage.getTitleStyle();
        this.headCellStyle = this.themesManage.getHeadStyle();
        this.contentCellStyle = this.themesManage.getContentStyle();
    }

    protected final void newSheet() {
        this.newSheet("");
    }

    protected final void newSheet(ExcelSheet sheet) {
        this.newSheet(sheet.getSheetName());
        this.setFreezePanel(sheet);
        this.setSheetColumnWidth(sheet);
    }

    protected final void newSheet(String sheetName) {
        this.currentRowNum = 0;
        this.currentColNum = 0;
        this.isNotFirstRow = false;
        this.currentSheet = StringUtils.isBlank((CharSequence)sheetName) ? this.workbook.createSheet() : this.workbook.createSheet(sheetName);
        this.getContext().setSheet((Sheet)this.currentSheet);
    }

    protected final void newRow() {
        this.newRow(1);
    }

    protected final void newRow(int rowNum) {
        if (this.getContext().getSheet() == null) {
            throw new ExportException("\u8bf7\u5148\u521b\u5efasheet\u9875(newSheet()\u65b9\u6cd5)\uff0c\u518d\u6267\u884c\u5bf9sheet\u9875\u7684\u8bbe\u7f6e\u7b49\u64cd\u4f5c");
        }
        if (rowNum < 1) {
            throw new ExportException("\u8c03\u7528newRow(int rowNum)\u65f6\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{rowNum\uff1a[" + rowNum + "]}\u4e2d\u521b\u5efa\u7684\u884c\u6570rowNum\u5fc5\u987b>0");
        }
        if (this.isNotFirstRow) {
            this.currentRowNum += rowNum;
        }
        this.currentColNum = 0;
        this.currentRow = this.currentSheet.createRow(this.currentRowNum);
        this.getContext().setRow((Row)this.currentRow);
        if (this.currentRowNum == 0) {
            this.isNotFirstRow = true;
        }
    }

    protected final void setCellContent(Object content, CellTypeEnum cellType, Integer rowspan, Integer colspan, CellStyle customStyle) {
        if (this.getContext().getSheet() == null) {
            throw new ExportException("\u8bf7\u5148\u521b\u5efasheet\u9875(newSheet())\uff0c\u518d\u6267\u884c\u5bf9sheet\u9875\u7684\u8bbe\u7f6e\u7b49\u64cd\u4f5c");
        }
        if (rowspan <= 0 || colspan <= 0) {
            throw new ExportException("\u8c03\u7528\u5355\u5143\u683c\u8bbe\u503c\u51fd\u6570\u65f6\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{rowspan\uff1a[" + rowspan + "]\uff0ccolspan\uff1a[" + colspan + "]}\u4e2d\u8bbe\u7f6e\u7684\u884c\u3001\u5217\u6570\u5fc5\u987b>0");
        }
        if (cellType == null || customStyle == null) {
            throw new ExportException("\u8c03\u7528\u5355\u5143\u683c\u8bbe\u503c\u51fd\u6570\u65f6\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{content\uff1a[" + content + "]\uff0ccellType[" + (Object)((Object)cellType) + "]\uff0ccustomStyle\uff1a[" + customStyle + "]}\u4e2d\u5b58\u5728\u7a7a\u53c2\u6570\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.setRowspan(rowspan, colspan);
        this.dealRowspan(cellType, customStyle);
        this.setCellValue(cellType, content, customStyle);
        this.dealMerge(rowspan, colspan, customStyle);
        this.currentColNum += colspan.intValue();
    }

    private void setCellValue(CellTypeEnum cellType, Object value, CellStyle cellStyle) {
        this.currentCell = this.currentRow.createCell(this.currentColNum);
        this.currentCell.setCellStyle(cellStyle);
        this.getContext().setCell((Cell)this.currentCell);
        if (null != cellType) {
            this.getContext().setCellType(cellType);
        }
        this.getContext().addExtend("SET_CELL_VALUE", value);
        this.cellValueManage.setValue();
    }

    private void dealMerge(Integer rowspan, Integer colspan, CellStyle cellStyle) {
        if (rowspan != 1 || colspan != 1) {
            CellRangeAddress rangeAddress = new CellRangeAddress(this.currentRowNum, this.currentRowNum + rowspan - 1, this.currentColNum, this.currentColNum + colspan - 1);
            this.currentSheet.addMergedRegion(rangeAddress);
        }
        for (int i = 1; i < colspan; ++i) {
            this.currentCell = this.currentRow.createCell(this.currentColNum + i);
            this.currentCell.setCellStyle(cellStyle);
        }
    }

    private void setRowspan(Integer rowspan, Integer colspan) {
        if (rowspan > 1) {
            for (int i = 1; i < rowspan; ++i) {
                Map<Integer, Integer> cols = this.rowAffect.get(this.currentRowNum + i);
                if (CollectionUtils.isEmpty(cols)) {
                    cols = new HashMap<Integer, Integer>();
                }
                cols.put(this.currentColNum, colspan);
                this.rowAffect.put(this.currentRowNum + i, cols);
            }
        }
    }

    private void dealRowspan(CellTypeEnum cellType, CellStyle cellStyle) {
        Map<Integer, Integer> cols = this.rowAffect.get(this.currentRowNum);
        if (!CollectionUtils.isEmpty(cols) && null != cols.get(this.currentColNum) && 0 != cols.get(this.currentColNum)) {
            int colsNum = cols.get(this.currentColNum);
            for (int i = 0; i < colsNum; ++i) {
                this.setCellValue(cellType, "", cellStyle);
                ++this.currentColNum;
            }
            this.dealRowspan(cellType, cellStyle);
        }
    }

    protected void fixStyle(int colNum, CellStyle cellStyle) {
        this.currentColNum = colNum;
        this.setCellValue(CellTypeEnum.STRING, "", cellStyle);
    }

    protected final void setExcelTitle(String title, CellTypeEnum cellType, Integer rowspan, Integer colspan) {
        if (this.getContext().getSheet() == null) {
            throw new ExportException("\u8bf7\u5148\u521b\u5efasheet\u9875(newSheet())\uff0c\u518d\u6267\u884c\u5bf9sheet\u9875\u7684\u8bbe\u7f6e\u7b49\u64cd\u4f5c");
        }
        if (rowspan <= 0 || colspan <= 0) {
            throw new ExportException("\u8c03\u7528\u8bbe\u7f6e\u51fd\u6570setExcelTitle\u65f6\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{rowspan\uff1a[" + rowspan + "]\uff0ccolspan\uff1a[" + colspan + "]}\u4e2d\u8bbe\u7f6e\u7684\u884c\u3001\u5217\u6570\u5fc5\u987b>0");
        }
        if (title == null) {
            throw new ExportException("\u8c03\u7528\u8bbe\u7f6e\u51fd\u6570setExcelTitle\u65f6\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{title\uff1a[" + title + "]}\u4e2d\u8868\u683c\u6807\u9898title\u4e3a\u7a7a\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.newRow();
        this.setCellContent(title, cellType, rowspan, colspan, this.titleCellStyle);
    }

    protected final ExcelSheet getSheet(int index) {
        if (index > this.setting.getSheets().size()) {
            throw new ExportException("\u8c03\u7528getSheet(int index)\u51fd\u6570\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{index\uff1a[" + index + "]}\u4e2d\u53c2\u6570index\u8d8a\u754c\uff0cindex\u4e0d\u80fd\u8d85\u8fc7controller\u4e2d\u8bbe\u7f6esheet\u9875\u7684\u4e2a\u6570");
        }
        return this.setting.getSheets().get(index - 1);
    }

    protected final void setSheetCommonColWidth(int commonWidth, int countCol) {
        if (this.getContext().getSheet() == null) {
            throw new ExportException("\u8bf7\u5148\u521b\u5efasheet\u9875(newSheet())\uff0c\u518d\u6267\u884c\u5bf9sheet\u9875\u7684\u8bbe\u7f6e\u7b49\u64cd\u4f5c");
        }
        if (commonWidth < 0 || countCol <= 0) {
            throw new ExportException("\u8c03\u7528setSheetCommonColWidth\u51fd\u6570\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{commonWidth\uff1a[" + commonWidth + "]\uff0ccountCol\uff1a[" + countCol + "]}\u4e2d\u53c2\u6570\u8d8a\u754c\uff0c\u8bf7\u4f20\u9012\u5927\u4e8e0\u7684\u5bbd\u5ea6\u548c\u5217\u6570");
        }
        for (int i = 0; i < countCol; ++i) {
            this.getContext().getSheet().setColumnWidth(i, commonWidth * 256);
        }
    }

    protected final void setSheetCustomColWidth(int colNum, int colWidth) {
        if (colNum <= 0 || colWidth <= 0) {
            throw new ExportException("\u8c03\u7528setSheetCommonColWidth\u51fd\u6570\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{colNum\uff1a[" + colNum + "]\uff0ccolWidth\uff1a[" + colWidth + "]}\u4e2d\u53c2\u6570\u8d8a\u754c\uff0c\u8bf7\u4f20\u9012\u5927\u4e8e0\u7684\u5bbd\u5ea6\u548c\u5217\u6570");
        }
        this.getContext().getSheet().setColumnWidth(colNum - 1, colWidth * 256);
    }

    protected final void setFreezePane(int freezeRows, int freezeCols) {
        if (this.getContext().getSheet() == null) {
            throw new ExportException("\u8bf7\u5148\u521b\u5efasheet\u9875(newSheet())\uff0c\u518d\u6267\u884c\u5bf9sheet\u9875\u7684\u8bbe\u7f6e\u7b49\u64cd\u4f5c");
        }
        if (freezeRows < 0 || freezeCols < 0) {
            throw new ExportException("\u8c03\u7528setFreezePane\u51fd\u6570\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{freezeRows\uff1a[" + freezeRows + "]\uff0cfreezeCols\uff1a[" + freezeCols + "]}\u4e2d\u53c2\u6570\u8d8a\u754c\uff0c\u8bf7\u4f20\u9012\u5927\u4e8e\u7b49\u4e8e0\u7684\u884c\u6570\u548c\u5217\u6570");
        }
        this.currentSheet.createFreezePane(freezeRows, freezeCols, freezeRows, freezeCols);
    }

    protected void setCellContent(Object content, Integer rowspan, Integer colspan, CellStyle customStyle) {
        this.setCellContent(content, CellTypeEnum.STRING, rowspan, colspan, customStyle);
    }

    protected void setCellContent(Object content, CellTypeEnum cellType, CellStyle customStyle) {
        this.setCellContent(content, cellType, 1, 1, customStyle);
    }

    protected void setCellContent(Object content, CellTypeEnum cellType) {
        this.setCellContent(content, cellType, 1, 1, this.getContentCellStyle());
    }

    protected void setHeadCellContent(Object content, CellTypeEnum cellType, Integer rowspan, Integer colspan) {
        this.setCellContent(content, cellType, rowspan, colspan, this.getHeadCellStyle());
    }

    protected void setContentCellContent(Object content, CellTypeEnum cellType, Integer rowspan, Integer colspan) {
        this.setCellContent(content, cellType, rowspan, colspan, this.getContentCellStyle());
    }

    protected void setCellContent(Object content, CellStyle customStyle) {
        this.setCellContent(content, CellTypeEnum.STRING, 1, 1, null == customStyle ? this.getContentCellStyle() : customStyle);
    }

    protected void setCellContent(Object content) {
        this.setCellContent(content, this.getContentCellStyle());
    }

    protected void setHeadCellContent(Object content, Integer rowspan, Integer colspan) {
        this.setCellContent(content, CellTypeEnum.STRING, rowspan, colspan, this.getHeadCellStyle());
    }

    protected void setContentCellContent(Object content, Integer rowspan, Integer colspan) {
        this.setCellContent(content, CellTypeEnum.STRING, rowspan, colspan, this.getContentCellStyle());
    }

    protected void setHeadCellContent(Object content, CellTypeEnum cellType) {
        this.setCellContent(content, cellType, 1, 1, this.getHeadCellStyle());
    }

    protected void setContentCellContent(Object content, CellTypeEnum cellType) {
        this.setCellContent(content, cellType, 1, 1, this.getContentCellStyle());
    }

    protected void setHeadCellContent(Object content) {
        this.setCellContent(content, CellTypeEnum.STRING, 1, 1, this.getHeadCellStyle());
    }

    protected void setContentCellContent(Object content) {
        this.setCellContent(content, CellTypeEnum.STRING, 1, 1, this.getContentCellStyle());
    }

    protected void setFreezePanel(ExcelSheet sheet) {
        if (sheet.isFreezeHeader()) {
            int colIndex = 1;
            if (StringUtils.isNotBlank((CharSequence)sheet.getContentTitle())) {
                colIndex = 2;
            }
            this.currentSheet.createFreezePane(0, colIndex, 0, colIndex);
        }
    }

    protected void setSheetColumnWidth(ExcelSheet sheet) {
        int defaultWidth = sheet.getDefaultWidth();
        for (SheetHeader header : sheet.getHeaders()) {
            if (0 == header.getWidth()) {
                if (0 == defaultWidth) {
                    this.currentSheet.autoSizeColumn(this.currentColNum);
                } else {
                    this.setSheetCustomColWidth(this.currentColNum + 1, defaultWidth);
                }
            } else {
                this.setSheetCustomColWidth(this.currentColNum + 1, header.getWidth());
            }
            ++this.currentColNum;
        }
    }

    protected void createHeader(List<SheetHeader> headers) {
        this.newRow();
        for (SheetHeader header : headers) {
            this.setCellContent((Object)header.getTitle(), this.getHeadCellStyle());
        }
    }

    @Override
    public ExcelThemesManage getThemesManage() {
        return this.themesManage;
    }

    @Override
    @Autowired
    public void setThemesManage(ExcelThemesManage themesManage) {
        this.themesManage = themesManage;
    }

    @Override
    public CellValueManage getCellValueManage() {
        return this.cellValueManage;
    }

    @Override
    @Autowired
    public void setCellValueManage(CellValueManage cellValueManage) {
        this.cellValueManage = cellValueManage;
    }

    public CellStyle getTitleCellStyle() {
        return this.titleCellStyle;
    }

    public CellStyle getHeadCellStyle() {
        return this.headCellStyle;
    }

    public CellStyle getContentCellStyle() {
        return this.contentCellStyle;
    }
}

