/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.office.excel.export.impl;

import com.bxm.component.office.excel.export.impl.AbstractExcelExport;
import com.bxm.component.office.excel.export.setting.ExcelSheet;
import com.bxm.component.office.excel.export.setting.SheetHeader;
import com.bxm.newidea.component.vo.BaseBean;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
@Scope(value="prototype")
public class SimpleExcelExporter
extends AbstractExcelExport {
    @Override
    protected void execExport() {
        this.createSheet();
    }

    private void createSheet() {
        for (ExcelSheet sheet : this.setting.getSheets()) {
            this.newSheet(sheet);
            if (StringUtils.isNotBlank((String)sheet.getContentTitle())) {
                this.createTitle(sheet.getContentTitle(), sheet.getHeaders());
            }
            this.createHeader(sheet.getHeaders());
            this.createContent(sheet);
        }
    }

    private void createTitle(String title, List<SheetHeader> headers) {
        int endCol = headers.size();
        this.newRow();
        this.setCellContent(title, 1, endCol, this.getTitleCellStyle());
    }

    private void createContent(ExcelSheet sheet) {
        block9: {
            block8: {
                if (null == sheet.getDataCollection()) break block8;
                for (BaseBean baseBean : sheet.getDataCollection()) {
                    this.newRow();
                    for (SheetHeader header : sheet.getHeaders()) {
                        Object value = null;
                        try {
                            Field field = ReflectionUtils.findField(baseBean.getClass(), (String)header.getField());
                            if (null == field) {
                                this.LOGGER.info("[{}]\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728[{}]", baseBean.getClass(), (Object)header.getField());
                            } else {
                                ReflectionUtils.makeAccessible((Field)field);
                                value = ReflectionUtils.getField((Field)field, (Object)baseBean);
                            }
                        }
                        catch (Exception e) {
                            this.LOGGER.error("\u627e\u4e0d\u5230" + header.getField() + "\u7684\u503c");
                        }
                        this.getContext().addExtend("EXPORT_HEADER", header);
                        this.setContentCellContent(value, header.getCellType());
                    }
                }
                break block9;
            }
            if (null == sheet.getDataMap()) break block9;
            for (Map<String, Object> map : sheet.getDataMap()) {
                this.newRow();
                for (SheetHeader header : sheet.getHeaders()) {
                    Object value = map.get(header.getField());
                    this.getContext().addExtend("EXPORT_HEADER", header);
                    this.setContentCellContent(value, header.getCellType());
                }
            }
        }
    }
}

