/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.bootstrap;

import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.counter.JobCounter;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.storage.LongTermJobRepository;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchLongTermJobRunner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FetchLongTermJobRunner.class);
    private RecentJobRepository recentJobRepository;
    private LongTermJobRepository longTermJobRepository;
    private ComponentOnceJobConfigurationProperties properties;

    @Override
    public void run() {
        long lastFetchMills = System.currentTimeMillis() + (long)this.properties.getFetchLongTermJobMills() + 60000L;
        this.queryByPageSize(lastFetchMills);
        log.info("{}", (Object)JobCounter.state());
    }

    private void queryByPageSize(long lastFetchMills) {
        List<JobPersistentObject> jobs = this.longTermJobRepository.query(lastFetchMills, this.properties.getLongTermFetchPageSize());
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u5230[{}]\u4e4b\u524d\u7684\u4efb\u52a1\u6570\u91cf\uff1a{}", (Object)lastFetchMills, (Object)jobs.size());
        }
        this.recentJobRepository.pushAll(jobs);
        if (jobs.size() == this.properties.getLongTermFetchPageSize()) {
            this.queryByPageSize(lastFetchMills);
        }
    }

    public FetchLongTermJobRunner(RecentJobRepository recentJobRepository, LongTermJobRepository longTermJobRepository, ComponentOnceJobConfigurationProperties properties) {
        this.recentJobRepository = recentJobRepository;
        this.longTermJobRepository = longTermJobRepository;
        this.properties = properties;
    }
}

