/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.bootstrap;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.counter.JobCounter;
import com.bxm.component.oncejob.enums.MissFireStrategy;
import com.bxm.component.oncejob.job.IOnceJobCallback;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.ReflectionUtils;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

class JobExecutor {
    private static final Logger log = LoggerFactory.getLogger(JobExecutor.class);
    private ComponentOnceJobConfigurationProperties properties;
    private ThreadPoolExecutor fastPoolExecutor;
    private Map<String, IOnceJobCallback> callbackMap;
    private ApplicationContext applicationContext;

    JobExecutor(ComponentOnceJobConfigurationProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
        this.callbackMap = Maps.newHashMap();
        this.init();
    }

    private void init() {
        ComponentOnceJobConfigurationProperties.ExecutorThreadPool threadPoolConfig = this.properties.getExecutorPool();
        this.fastPoolExecutor = new ThreadPoolExecutor(threadPoolConfig.getCoreSize(), threadPoolConfig.getMaxSize(), 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(threadPoolConfig.getQueueSize()), (ThreadFactory)new NamedThreadFactory("once-job-executor"), (r, executor) -> log.error("\u4efb\u52a1\u6570\u91cf\u8d85\u8fc7\u4e86\u7ebf\u7a0b\u6c60\u7684\u914d\u7f6e\uff0c\u8bf7\u6ce8\u610f\u8c03\u6574\uff0c\u5f53\u524d\u914d\u7f6e\uff1acore:{},max:{},queue:{}", new Object[]{threadPoolConfig.getCoreSize(), threadPoolConfig.getMaxSize(), threadPoolConfig.getQueueSize()}));
    }

    void submit(JobPersistentObject jobInfo) {
        JobCounter.addRunningCount();
        this.fastPoolExecutor.submit(() -> {
            IOnceJobCallback callback;
            try {
                callback = this.getCallback(jobInfo);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                JobCounter.addFailedCount();
                log.error(e.getMessage(), (Throwable)e);
                log.error("\u521b\u5efa\u4e00\u6b21\u6027\u4efb\u52a1\u56de\u8c03\u7c7b[{}]\u5931\u8d25\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u5b58\u5728\u53ef\u7528\u7684\u7a7a\u6784\u9020\u51fd\u6570\u6216\u6ce8\u5165\u5230\u4e86spring context", (Object)jobInfo.getCallbackClassName());
                return;
            }
            try {
                long diffMills = jobInfo.getFireDate() - System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug("\u4efb\u52a1\u5b9e\u9645\u6267\u884c\u548c\u8bbe\u5b9a\u65f6\u95f4\u76f8\u5dee\uff1a{}", (Object)diffMills);
                }
                if (Math.abs(diffMills) > 1000L) {
                    JobCounter.addExpiredCount();
                    log.warn("\u4efb\u52a1[{}][{}]\u6267\u884c\u504f\u5dee\u65f6\u95f4\u8d85\u8fc7\u4e86\u4e00\u79d2\u949f,\u9884\u8ba1\u6267\u884c\u65f6\u95f4\uff1a[{}],\u5b9e\u9645\u6267\u884c\u65f6\u95f4\uff1a[{}]", new Object[]{jobInfo.getJobId(), callback.getClass().getName(), DateUtils.formatDateTime((Date)new Date(jobInfo.getFireDate())), DateUtils.formatDateTime((Date)new Date())});
                    if (MissFireStrategy.NONE.name().equals(jobInfo.getMissFireStrategy())) {
                        log.info("\u4efb\u52a1[{}]\u8fc7\u671f\uff0c\u4e0d\u4e88\u6267\u884c", (Object)jobInfo.getJobId());
                        JobCounter.addFailedCount();
                        return;
                    }
                }
                TimeInterval timer = DateUtil.timer();
                boolean result = callback.execute(this.restoreParam(jobInfo, callback));
                if (timer.interval() > this.properties.getJobExpendWarningMills()) {
                    log.warn("\u4efb\u52a1\u56de\u8c03[{}]\u6267\u884c\u8d85\u8fc7\u4e86{}\u6beb\u79d2\uff0c\u8bf7\u6ce8\u610f\u4f18\u5316", (Object)jobInfo.getCallbackClassName(), (Object)this.properties.getJobExpendWarningMills());
                }
                if (result) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u4efb\u52a1[{}]\u6267\u884c\u6210\u529f", (Object)jobInfo.getJobId());
                    }
                    JobCounter.addSuccessCount();
                } else {
                    JobCounter.addFailedCount();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            JobCounter.removeRunningCount();
            if (log.isDebugEnabled()) {
                log.debug("{}", (Object)JobCounter.state());
            }
        });
    }

    void stop() {
        log.info("\u9884\u5907\u505c\u6b62\u672c\u5730\u4efb\u52a1\u5904\u7406,\u5f85\u5904\u7406\u4efb\u52a1\u6570\u91cf\uff1a{}", (Object)JobCounter.getRunningCount());
        try {
            TimeUnit.MILLISECONDS.sleep(JobCounter.getRunningCount() * 100);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.fastPoolExecutor.shutdown();
        if (JobCounter.getRunningCount() > 0) {
            log.error("\u672c\u5730\u4efb\u52a1\u6267\u884c\u5668\u5173\u95ed\uff0c\u5269\u4f59\u4efb\u52a1\uff1a{}", (Object)JobCounter.getRunningCount());
        } else {
            log.info("\u672c\u5730\u4efb\u52a1\u6267\u884c\u5668\u5173\u95ed");
        }
    }

    private Object restoreParam(JobPersistentObject jobInfo, IOnceJobCallback callback) {
        Class firstGenericType = ReflectionUtils.getFirstGenericType(callback.getClass());
        String jsonString = jobInfo.getParamJson();
        return JSON.parseObject((String)jsonString, (Class)firstGenericType);
    }

    private IOnceJobCallback getCallback(JobPersistentObject jobInfo) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String callbackClassName = jobInfo.getCallbackClassName();
        IOnceJobCallback callback = this.callbackMap.get(callbackClassName);
        if (callback == null) {
            Object callbackSpringBean;
            Class<?> callbackClass = Class.forName(callbackClassName);
            Map beansOfType = this.applicationContext.getBeansOfType(callbackClass);
            if (beansOfType.size() != 0 && (callbackSpringBean = beansOfType.values().iterator().next()) instanceof IOnceJobCallback) {
                callback = (IOnceJobCallback)callbackSpringBean;
            }
            if (null == callback) {
                callback = (IOnceJobCallback)callbackClass.newInstance();
            }
            this.callbackMap.put(callbackClassName, callback);
        }
        return callback;
    }
}

