/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.bootstrap;

import com.bxm.component.oncejob.bootstrap.FetchLongTermJobRunner;
import com.bxm.component.oncejob.bootstrap.FetchRecentJobRunner;
import com.bxm.component.oncejob.bootstrap.JobExecuteThread;
import com.bxm.component.oncejob.bootstrap.JobExecutor;
import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.storage.JobRepository;
import com.bxm.component.oncejob.storage.LongTermJobRepository;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.bxm.newidea.component.thread.UncaughtExceptionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class OnceJobTimerBootstrapper
implements ApplicationRunner,
DisposableBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(OnceJobTimerBootstrapper.class);
    private ComponentOnceJobConfigurationProperties properties;
    private RecentJobRepository recentJobRepository;
    private LongTermJobRepository longTermJobRepository;
    private JobRepository jobRepository;
    private ScheduledExecutorService fetchJobExecutor;
    private ScheduledExecutorService clearDirtyExecutor;
    private ScheduledExecutorService fetchLongTermExecutor;
    private JobExecuteThread jobExecuteThread;
    private ApplicationContext applicationContext;

    public OnceJobTimerBootstrapper(ComponentOnceJobConfigurationProperties properties, RecentJobRepository recentJobRepository, LongTermJobRepository longTermJobRepository, JobRepository jobRepository) {
        this.properties = properties;
        this.recentJobRepository = recentJobRepository;
        this.longTermJobRepository = longTermJobRepository;
        this.jobRepository = jobRepository;
    }

    public void run(ApplicationArguments args) {
        if (!this.properties.isEnable()) {
            log.info("\u5173\u95ed\u4e86\u4e00\u6b21\u6027\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\uff0c\u4e0d\u8fdb\u884c\u76f8\u5173\u4efb\u52a1\u7684\u521d\u59cb\u5316");
            return;
        }
        this.initFetchJobExecutor();
        this.initFetchLongTermExecutor();
        this.initClearDirtyExecutor();
        this.initJobExecutor();
    }

    private void initClearDirtyExecutor() {
        this.clearDirtyExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("once-job-clear-dirty", true));
        this.clearDirtyExecutor.scheduleAtFixedRate(() -> this.jobRepository.clearDirty(), 1000L, this.properties.getClearDirtyIntervalMills(), TimeUnit.MILLISECONDS);
    }

    private void initFetchJobExecutor() {
        this.fetchJobExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("once-job-fetch", true));
        long delay = System.currentTimeMillis() % (long)this.properties.getFetchIntervalMills();
        FetchRecentJobRunner fetchRecentJobRunner = new FetchRecentJobRunner(this.recentJobRepository, this.properties);
        this.fetchJobExecutor.scheduleAtFixedRate(fetchRecentJobRunner, delay, this.properties.getFetchIntervalMills(), TimeUnit.MILLISECONDS);
    }

    private void initFetchLongTermExecutor() {
        this.fetchLongTermExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("once-job-fetch-long", true));
        FetchLongTermJobRunner runner = new FetchLongTermJobRunner(this.recentJobRepository, this.longTermJobRepository, this.properties);
        long delay = System.currentTimeMillis() % (long)this.properties.getFetchLongTermJobMills();
        this.fetchLongTermExecutor.scheduleAtFixedRate(runner, delay, this.properties.getFetchLongTermJobMills(), TimeUnit.MILLISECONDS);
    }

    private void initJobExecutor() {
        JobExecutor jobExecutor = new JobExecutor(this.properties, this.applicationContext);
        this.jobExecuteThread = new JobExecuteThread(jobExecutor);
        this.jobExecuteThread.setDaemon(true);
        this.jobExecuteThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtExceptionHandler());
        this.jobExecuteThread.start();
    }

    public void destroy() {
        this.fetchJobExecutor.shutdown();
        log.info("fetchJobExecutor\u5173\u95ed\u5b8c\u6210");
        this.clearDirtyExecutor.shutdown();
        log.info("clearDirtyExecutor\u5173\u95ed\u5b8c\u6210");
        this.fetchLongTermExecutor.shutdown();
        log.info("fetchLongTermExecutor\u5173\u95ed\u5b8c\u6210");
        this.jobExecuteThread.stopThread();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

