/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.config;

import com.bxm.component.oncejob.bootstrap.OnceJobTimerBootstrapper;
import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.storage.JobRepository;
import com.bxm.component.oncejob.storage.LongTermJobRepository;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import com.bxm.component.oncejob.storage.impl.JobRepositoryImpl;
import com.bxm.component.oncejob.storage.memory.MemoryLongTermJobRepositoryImpl;
import com.bxm.component.oncejob.storage.memory.MemoryRecentJobRepositoryImpl;
import com.bxm.component.oncejob.storage.redis.RedisLongTermJobRepositoryImpl;
import com.bxm.component.oncejob.storage.redis.RedisRecentJobRepositoryImpl;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ComponentOnceJobConfigurationProperties.class})
@ConditionalOnProperty(prefix="component.once-job", name={"enable"}, matchIfMissing=true)
public class ComponentOnceJobAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ComponentOnceJobAutoConfiguration.class);
    private ComponentOnceJobConfigurationProperties properties;

    @Bean
    public OnceJobTimerBootstrapper bootstrapper(JobRepository jobRepository, RecentJobRepository recentJobRepository, LongTermJobRepository longTermJobRepository) {
        return new OnceJobTimerBootstrapper(this.properties, recentJobRepository, longTermJobRepository, jobRepository);
    }

    @Primary
    @Bean
    public JobRepository jobRepository(RecentJobRepository recentJobRepository, LongTermJobRepository longTermJobRepository) {
        return new JobRepositoryImpl(recentJobRepository, longTermJobRepository, this.properties);
    }

    @Bean
    @ConditionalOnProperty(prefix="component.once-job", name={"recentJobRepository"}, havingValue="redis")
    @ConditionalOnBean(value={RedisHashMapAdapter.class, RedisStringAdapter.class})
    public RecentJobRepository redisRecentJobRepository(RedisHashMapAdapter redisHashMapAdapter, DistributedLock distributedLock, RedisZSetAdapter redisZSetAdapter) {
        log.info("\u542f\u7528redis\u4f5c\u4e3a\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u77ed\u671f\u5b58\u50a8\u65b9\u6848");
        return new RedisRecentJobRepositoryImpl(this.properties, redisHashMapAdapter, distributedLock, redisZSetAdapter);
    }

    @Bean
    @ConditionalOnProperty(prefix="component.once-job", name={"longTermJobRepository"}, havingValue="redis")
    @ConditionalOnBean(value={RedisHashMapAdapter.class, RedisZSetAdapter.class})
    public LongTermJobRepository redisLongTermJobRepository(RedisHashMapAdapter redisHashMapAdapter, RedisZSetAdapter redisZSetAdapter, DistributedLock distributedLock) {
        log.info("\u542f\u7528redis\u4f5c\u4e3a\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u957f\u671f\u5b58\u50a8\u65b9\u6848");
        return new RedisLongTermJobRepositoryImpl(redisHashMapAdapter, this.properties, distributedLock, redisZSetAdapter);
    }

    @Bean
    @ConditionalOnProperty(prefix="component.once-job", name={"recentJobRepository"}, havingValue="memory")
    public RecentJobRepository memoryRecentJobRepository() {
        log.warn("\u542f\u7528memory\u4f5c\u4e3a\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u77ed\u671f\u5b58\u50a8\u65b9\u6848\uff0c\u5b9e\u4f8b\u505c\u6b62\u65f6\u4efb\u52a1\u5c06\u4f1a\u4e22\u5931");
        return new MemoryRecentJobRepositoryImpl();
    }

    @Bean
    @ConditionalOnProperty(prefix="component.once-job", name={"longTermJobRepository"}, havingValue="memory")
    public LongTermJobRepository memoryLongTermJobRepository(RecentJobRepository recentJobRepository) {
        log.warn("\u542f\u7528memory\u4f5c\u4e3a\u4e00\u6b21\u6027\u4efb\u52a1\u7684\u957f\u671f\u5b58\u50a8\u65b9\u6848\uff0c\u5b9e\u4f8b\u505c\u6b62\u65f6\u4efb\u52a1\u5c06\u4f1a\u4e22\u5931");
        return new MemoryLongTermJobRepositoryImpl(recentJobRepository);
    }

    public ComponentOnceJobAutoConfiguration(ComponentOnceJobConfigurationProperties properties) {
        this.properties = properties;
    }
}

