/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.dispatcher;

import com.bxm.component.oncejob.job.OnceJobDefinition;
import com.bxm.component.oncejob.storage.JobRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OnceJobDispatcher {
    private static final Logger log = LoggerFactory.getLogger(OnceJobDispatcher.class);
    private JobRepository jobRepository;

    public String push(OnceJobDefinition definition) {
        this.checkBuilder(definition);
        return this.jobRepository.saveJob(definition);
    }

    public void cancel(String jobId) {
        boolean removed = this.jobRepository.removeJob(jobId);
        if (!removed) {
            log.warn("\u4efb\u52a1[{}]\u5df2\u6267\u884c\u6216\u4e0d\u5b58\u5728\uff0c\u53d6\u6d88\u5931\u8d25", (Object)jobId);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u4efb\u52a1[{}]\u5df2\u7ecf\u5220\u9664\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}", (Object)jobId, (Object)removed);
        }
    }

    private void checkBuilder(OnceJobDefinition builder) {
        if (null == builder) {
            throw new IllegalArgumentException("\u53c2\u6570OnceJobBuilder\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (builder.getFireDate() == null) {
            throw new IllegalArgumentException("\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u5fc5\u987b\u63d0\u4f9b");
        }
        if (builder.getCallback() == null) {
            throw new IllegalArgumentException("\u4efb\u52a1\u56de\u8c03\u5bf9\u8c61\u5fc5\u987b\u63d0\u4f9b");
        }
    }

    public OnceJobDispatcher(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }
}

