/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.storage.impl;

import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.converter.JobConverter;
import com.bxm.component.oncejob.counter.JobCounter;
import com.bxm.component.oncejob.job.JobHolder;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.job.OnceJobDefinition;
import com.bxm.component.oncejob.storage.JobRepository;
import com.bxm.component.oncejob.storage.LongTermJobRepository;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import com.bxm.newidea.component.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRepositoryImpl
implements JobRepository {
    private static final Logger log = LoggerFactory.getLogger(JobRepositoryImpl.class);
    private RecentJobRepository recentJobRepository;
    private LongTermJobRepository longTermJobRepository;
    private ComponentOnceJobConfigurationProperties properties;

    @Override
    public String saveJob(OnceJobDefinition definition) {
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u4e00\u6b21\u6027\u5b9a\u65f6\u4efb\u52a1\uff1a{}", (Object)JSON.toJSONString((Object)definition));
        }
        JobCounter.addCreateCount();
        if (definition.getFireDate().getTime() - System.currentTimeMillis() <= (long)this.properties.getFetchIntervalMills()) {
            JobPersistentObject persistentObject = JobConverter.convert(definition);
            JobHolder.pushJob(persistentObject);
            return persistentObject.getJobId();
        }
        if (definition.getFireDate().getTime() - System.currentTimeMillis() > (long)this.properties.getFetchLongTermJobMills()) {
            return this.longTermJobRepository.saveJob(definition);
        }
        return this.recentJobRepository.saveJob(definition);
    }

    @Override
    public boolean removeJob(String jobId) {
        boolean removed = JobHolder.removeJob(jobId);
        if (!removed && !(removed = this.recentJobRepository.removeJob(jobId))) {
            removed = this.longTermJobRepository.removeJob(jobId);
        }
        return removed;
    }

    @Override
    public List<JobPersistentObject> clearDirty() {
        if (log.isDebugEnabled()) {
            log.debug("\u6267\u884c\u810f\u6570\u636e\u6e05\u7406");
        }
        List<JobPersistentObject> jobPersistentObjects = this.recentJobRepository.clearDirty();
        jobPersistentObjects.addAll(this.longTermJobRepository.clearDirty());
        ArrayList recentList = Lists.newArrayList();
        for (JobPersistentObject jobPersistentObject : jobPersistentObjects) {
            if (jobPersistentObject.getFireDate() - System.currentTimeMillis() <= (long)this.properties.getFetchIntervalMills()) {
                JobHolder.pushJob(jobPersistentObject);
                continue;
            }
            recentList.add(jobPersistentObject);
        }
        this.recentJobRepository.pushAll(recentList);
        JobHolder.clearDirty();
        log.info("{}", (Object)JobCounter.state());
        return jobPersistentObjects;
    }

    public JobRepositoryImpl(RecentJobRepository recentJobRepository, LongTermJobRepository longTermJobRepository, ComponentOnceJobConfigurationProperties properties) {
        this.recentJobRepository = recentJobRepository;
        this.longTermJobRepository = longTermJobRepository;
        this.properties = properties;
    }
}

