/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.storage.redis;

import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.constant.OnceJobRedisKey;
import com.bxm.component.oncejob.converter.JobConverter;
import com.bxm.component.oncejob.job.JobIdUtil;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.job.OnceJobDefinition;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import com.bxm.component.oncejob.utils.FragmentIndexUtil;
import com.bxm.newidea.component.entity.TypedTuple;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisRecentJobRepositoryImpl
implements RecentJobRepository {
    private static final Logger log = LoggerFactory.getLogger(RedisRecentJobRepositoryImpl.class);
    private ComponentOnceJobConfigurationProperties properties;
    private RedisHashMapAdapter redisHashMapAdapter;
    private DistributedLock distributedLock;
    private RedisZSetAdapter redisZSetAdapter;

    public RedisRecentJobRepositoryImpl(ComponentOnceJobConfigurationProperties properties, RedisHashMapAdapter redisHashMapAdapter, DistributedLock distributedLock, RedisZSetAdapter redisZSetAdapter) {
        this.properties = properties;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.distributedLock = distributedLock;
        this.redisZSetAdapter = redisZSetAdapter;
    }

    @Override
    public String saveJob(OnceJobDefinition definition) {
        return this.savePersistentObject(JobConverter.convert(definition));
    }

    private String savePersistentObject(JobPersistentObject persistentObject) {
        String jobId = persistentObject.getJobId();
        long fragmentIndex = FragmentIndexUtil.getFragmentIndex(persistentObject.getFireDate(), this.properties.getFetchIntervalMills());
        KeyGenerator key = this.getJobFragmentIndexKey(fragmentIndex);
        this.redisHashMapAdapter.put(key, jobId, (Object)persistentObject);
        this.redisZSetAdapter.add(OnceJobRedisKey.JOB_FRAGMENT_INDEX_KEY, (Object)fragmentIndex, (double)fragmentIndex);
        return jobId;
    }

    @Override
    public void pushAll(List<JobPersistentObject> jobs) {
        for (JobPersistentObject job : jobs) {
            this.savePersistentObject(job);
        }
    }

    private KeyGenerator getJobFragmentIndexKey(long fragmentIndex) {
        return OnceJobRedisKey.JOB_FRAGMENT_KEY.copy().appendKey((Object)this.properties.getAppName()).appendKey((Object)fragmentIndex);
    }

    @Override
    public boolean removeJob(String jobId) {
        if (log.isDebugEnabled()) {
            log.debug("\u79fb\u9664\u4e00\u6b21\u6027\u4efb\u52a1:{}", (Object)jobId);
        }
        long fragmentIndex = FragmentIndexUtil.getFragmentIndex(JobIdUtil.getFireMills(jobId), this.properties.getFetchIntervalMills());
        KeyGenerator key = this.getJobFragmentIndexKey(fragmentIndex);
        return this.redisHashMapAdapter.remove(key, new String[]{jobId}) > 0L;
    }

    @Override
    public List<JobPersistentObject> load(long lastFireTimeMills, int num) {
        long fragmentIndex = FragmentIndexUtil.getFragmentIndex(lastFireTimeMills, this.properties.getFetchIntervalMills());
        String resource = OnceJobRedisKey.JOB_FRAGMENT_INDEX_LOCK_KEY.copy().appendKey((Object)this.properties.getAppName()).appendKey((Object)fragmentIndex).gen();
        List<Object> preFetch = Lists.newArrayList();
        if (this.distributedLock.lock(resource)) {
            preFetch = this.loadInterval(fragmentIndex);
            if (log.isDebugEnabled()) {
                log.debug("\u9884\u52a0\u8f7d\u4e00\u6b21\u6027\u4efb\u52a1\uff0c\u52a0\u8f7d\u65f6\u95f4\u70b9:[{}],\u52a0\u8f7d\u7247\u533a:[{}],\u52a0\u8f7d\u6570\u91cf:[{}]", new Object[]{lastFireTimeMills, fragmentIndex, preFetch.size()});
            }
            this.distributedLock.unlock(resource);
        }
        return preFetch;
    }

    private List<JobPersistentObject> loadInterval(long fragmentIndex) {
        KeyGenerator key = this.getJobFragmentIndexKey(fragmentIndex);
        List values = this.redisHashMapAdapter.values(key, JobPersistentObject.class);
        this.redisHashMapAdapter.remove(key);
        this.redisZSetAdapter.remove(OnceJobRedisKey.JOB_FRAGMENT_INDEX_KEY, new Object[]{fragmentIndex});
        return values;
    }

    @Override
    public List<JobPersistentObject> clearDirty() {
        String lockKey = OnceJobRedisKey.JOB_RECENT_DIRTY_LOCK_KEY.gen();
        ArrayList result = Lists.newArrayList();
        if (this.distributedLock.lock(lockKey)) {
            long fragmentIndex = FragmentIndexUtil.getFragmentIndex(System.currentTimeMillis(), this.properties.getFetchIntervalMills());
            Set typedTuples = this.redisZSetAdapter.rangeByScoreWithScores(OnceJobRedisKey.JOB_FRAGMENT_INDEX_KEY, 0.0, (double)fragmentIndex, true, Long.class);
            log.info("\u53d1\u73b0[{}]\u4e2a\u672a\u5904\u7406\u7684\u65f6\u95f4\u7247\u6bb5", (Object)typedTuples.size());
            for (TypedTuple typedTuple : typedTuples) {
                result.addAll(this.loadInterval((Long)typedTuple.getValue()));
            }
            this.distributedLock.unlock(lockKey);
        } else {
            log.warn("\u5176\u4ed6\u5b9e\u4f8b\u6b63\u5728\u5904\u7406\u810f\u6570\u636e\uff0c\u653e\u5f03\u672c\u6b21\u5904\u7406");
        }
        return result;
    }
}

