/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.bootstrap;

import com.bxm.component.oncejob.bootstrap.JobExecutor;
import com.bxm.component.oncejob.bootstrap.JobHolder;
import com.bxm.component.oncejob.job.JobPersistentObject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExecuteThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(JobExecuteThread.class);
    private JobExecutor jobExecutor;
    private AtomicBoolean threadToStop = new AtomicBoolean(false);

    public JobExecuteThread(JobExecutor jobExecutor) {
        super("once-job-executor");
        this.jobExecutor = jobExecutor;
    }

    @Override
    public void run() {
        while (!this.threadToStop.get()) {
            block6: {
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L - System.currentTimeMillis() % 1000L);
                }
                catch (InterruptedException e) {
                    if (this.threadToStop.get()) break block6;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                List<JobPersistentObject> executeJobs = JobHolder.getCurrentSecondExecuteJobs();
                if (executeJobs == null) continue;
                for (JobPersistentObject executeJob : executeJobs) {
                    this.jobExecutor.submit(executeJob);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stopThread() {
        if (JobHolder.isEmpty()) {
            this.threadToStop.set(true);
        } else {
            log.info("\u5b58\u5728\u9884\u52a0\u8f7d\u7684\u8c03\u5ea6\u4efb\u52a1\uff0c\u7b49\u5f85\u5904\u7406");
            do {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    this.threadToStop.set(true);
                }
            } while (!JobHolder.isEmpty());
            this.threadToStop.set(true);
            log.info("\u9884\u52a0\u8f7d\u4efb\u52a1\u5904\u7406\u5b8c\u6210");
        }
        log.info("\u505c\u6b62\u5904\u7406\u672c\u5730\u9884\u62c9\u53d6\u7684\u8c03\u5ea6\u4efb\u52a1");
        this.jobExecutor.stop();
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (Thread.currentThread().getState() != Thread.State.TERMINATED) {
            Thread.currentThread().interrupt();
        }
        log.info("\u5173\u95ed\u6267\u884c\u7ebf\u7a0bJobExecuteThread");
    }
}

