/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.bootstrap;

import com.bxm.component.oncejob.counter.JobCounter;
import com.bxm.component.oncejob.enums.MissFireStrategy;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobHolder {
    private static final Logger log = LoggerFactory.getLogger(JobHolder.class);
    private static Map<Long, List<JobPersistentObject>> jobQueueMap = Maps.newConcurrentMap();

    public static void pushJob(JobPersistentObject jobInfo) {
        if (log.isDebugEnabled()) {
            log.debug("\u6dfb\u52a0\u4efb\u52a1\u5230\u672c\u5730\u961f\u5217\uff1a{}", (Object)jobInfo.getJobId());
        }
        long executeSecond = jobInfo.getFireDate() / 1000L;
        List waitExecuteJobs = jobQueueMap.getOrDefault(executeSecond, new ArrayList());
        waitExecuteJobs.add(jobInfo);
        JobCounter.addQueueCount();
        jobQueueMap.put(executeSecond, waitExecuteJobs);
    }

    public static boolean isEmpty() {
        return jobQueueMap.size() == 0;
    }

    public static boolean removeJob(String jobId) {
        for (List<JobPersistentObject> jobs : jobQueueMap.values()) {
            for (JobPersistentObject job : jobs) {
                if (!StringUtils.equals((CharSequence)jobId, (CharSequence)job.getJobId())) continue;
                jobs.remove(job);
                JobCounter.consumeQueueCount(1);
                return true;
            }
        }
        return false;
    }

    public static List<JobPersistentObject> getCurrentSecondExecuteJobs() {
        long executeSecond = System.currentTimeMillis() / 1000L;
        List<JobPersistentObject> result = jobQueueMap.remove(executeSecond);
        if (log.isDebugEnabled()) {
            if (null != result && result.size() > 0) {
                log.debug("[{}]\u79d2\u9700\u8981\u6267\u884c\u7684\u4efb\u52a1\u6709[{}]\u4e2a", (Object)executeSecond, (Object)result.size());
            } else {
                log.debug("[{}]\u79d2\u6ca1\u6709\u8981\u6267\u884c\u7684\u4efb\u52a1", (Object)executeSecond);
            }
        }
        if (null != result) {
            JobCounter.consumeQueueCount(result.size());
        }
        return result;
    }

    public static void clearDirty() {
        long currentSecond = System.currentTimeMillis() / 1000L;
        long nextSecond = currentSecond + 1L;
        long preSecond = currentSecond - 1L;
        for (Map.Entry<Long, List<JobPersistentObject>> entry : jobQueueMap.entrySet()) {
            if (entry.getKey() >= preSecond) continue;
            log.error("[{}]\u79d2\u7684\u4efb\u52a1\u672a\u80fd\u6b63\u786e\u6267\u884c\uff0c\u5171\uff1a[{}]\u4e2a\uff0c\u73b0\u5728\u8fdb\u884c\u8865\u5145\u6267\u884c", (Object)entry.getKey(), (Object)entry.getValue().size());
            List<JobPersistentObject> jobs = jobQueueMap.remove(entry.getKey());
            jobs = jobs.stream().filter(job -> MissFireStrategy.REMAIN.name().equals(job.getMissFireStrategy())).collect(Collectors.toList());
            List waitExecuteJobs = jobQueueMap.getOrDefault(nextSecond, new ArrayList());
            waitExecuteJobs.addAll(jobs);
            jobQueueMap.put(nextSecond, waitExecuteJobs);
        }
    }

    private JobHolder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

