/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.oncejob.storage.redis;

import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.constant.OnceJobRedisKey;
import com.bxm.component.oncejob.converter.JobConverter;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.job.OnceJobDefinition;
import com.bxm.component.oncejob.storage.LongTermJobRepository;
import com.bxm.component.oncejob.utils.JobIdUtil;
import com.bxm.newidea.component.entity.TypedTuple;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLongTermJobRepositoryImpl
implements LongTermJobRepository {
    private static final Logger log = LoggerFactory.getLogger(RedisLongTermJobRepositoryImpl.class);
    private RedisHashMapAdapter redisHashMapAdapter;
    private ComponentOnceJobConfigurationProperties properties;
    private DistributedLock distributedLock;
    private RedisZSetAdapter redisZSetAdapter;

    @Override
    public String saveJob(OnceJobDefinition definition) {
        JobPersistentObject persistentObject = JobConverter.convert(definition);
        long index = persistentObject.getFireDate() / (long)this.properties.getFetchLongTermJobMills();
        KeyGenerator key = OnceJobRedisKey.JOB_LONG_TERM_KEY.copy().appendKey((Object)index);
        this.redisHashMapAdapter.put(key, persistentObject.getJobId(), (Object)persistentObject);
        this.redisZSetAdapter.add(OnceJobRedisKey.JOB_LONG_TERM_INDEX_KEY, (Object)index, (double)index);
        return persistentObject.getJobId();
    }

    @Override
    public boolean removeJob(String jobId) {
        long fireMills = JobIdUtil.getFireMills(jobId);
        long index = fireMills / (long)this.properties.getFetchLongTermJobMills();
        KeyGenerator key = OnceJobRedisKey.JOB_LONG_TERM_KEY.copy().appendKey((Object)index);
        return this.redisHashMapAdapter.remove(key, new String[]{jobId}) > 0L;
    }

    @Override
    public List<JobPersistentObject> clearDirty() {
        String lockKey = OnceJobRedisKey.JOB_LONG_TERM_DIRTY_LOCK_KEY.gen();
        ArrayList result = Lists.newArrayList();
        if (this.distributedLock.lock(lockKey)) {
            long index = System.currentTimeMillis() / (long)this.properties.getFetchLongTermJobMills() + 1L;
            Set typedTuples = this.redisZSetAdapter.rangeByScoreWithScores(OnceJobRedisKey.JOB_LONG_TERM_INDEX_KEY, 0.0, (double)index, true, Long.class);
            log.info("\u53d1\u73b0[{}]\u4e2a\u672a\u5904\u7406\u7684\u65f6\u95f4\u7247\u6bb5", (Object)typedTuples.size());
            for (TypedTuple typedTuple : typedTuples) {
                result.addAll(this.clearInterval((Long)typedTuple.getValue()));
            }
            this.distributedLock.unlock(lockKey);
        } else {
            log.warn("\u5176\u4ed6\u5b9e\u4f8b\u6b63\u5728\u5904\u7406\u810f\u6570\u636e\uff0c\u653e\u5f03\u672c\u6b21\u5904\u7406");
        }
        return result;
    }

    private List<JobPersistentObject> clearInterval(long index) {
        KeyGenerator key = OnceJobRedisKey.JOB_LONG_TERM_KEY.copy().appendKey((Object)index);
        List values = this.redisHashMapAdapter.values(key, JobPersistentObject.class);
        if (null != values) {
            this.redisHashMapAdapter.remove(key);
            this.redisZSetAdapter.remove(OnceJobRedisKey.JOB_LONG_TERM_INDEX_KEY, new Object[]{index});
            log.warn("\u8865\u507f\u5904\u7406\u5386\u53f2\u6570\u636e,\u7d22\u5f15\u4e3a\uff1a{}", (Object)key.gen());
        }
        return values;
    }

    @Override
    public List<JobPersistentObject> query(long lastFireTimeMills, int num) {
        String lockKey = OnceJobRedisKey.JOB_LONG_TERM_LOCK_KEY.gen();
        if (this.distributedLock.lock(lockKey)) {
            long index = lastFireTimeMills / (long)this.properties.getFetchLongTermJobMills();
            KeyGenerator key = OnceJobRedisKey.JOB_LONG_TERM_KEY.copy().appendKey((Object)index);
            List values = this.redisHashMapAdapter.values(key, JobPersistentObject.class);
            this.redisHashMapAdapter.remove(key);
            this.redisZSetAdapter.removeByScore(OnceJobRedisKey.JOB_LONG_TERM_INDEX_KEY, (double)index, (double)index);
            this.distributedLock.unlock(lockKey);
            return values;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u4e0d\u4e88\u6267\u884c");
        }
        return Lists.newArrayList();
    }

    public RedisLongTermJobRepositoryImpl(RedisHashMapAdapter redisHashMapAdapter, ComponentOnceJobConfigurationProperties properties, DistributedLock distributedLock, RedisZSetAdapter redisZSetAdapter) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.properties = properties;
        this.distributedLock = distributedLock;
        this.redisZSetAdapter = redisZSetAdapter;
    }
}

