package com.bxm.component.oncejob.bootstrap;

import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.counter.JobCounter;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.storage.LongTermJobRepository;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * 从长期的任务存储中拉取任务，放置到短期存储中
 *
 * @author liujia
 * @date 8/2/21 6:50 PM
 **/
@Slf4j
@AllArgsConstructor
public class FetchLongTermJobRunner implements Runnable {

    private RecentJobRepository recentJobRepository;

    private LongTermJobRepository longTermJobRepository;

    private ComponentOnceJobConfigurationProperties properties;

    @Override
    public void run() {
        // 拉取长期任务，在拉取的间隔上额外增加一分钟，防止出现临界任务
        long lastFetchMills = System.currentTimeMillis() + properties.getFetchLongTermJobMills() + DateUtils.MINUTE_MILLISECOND;

        queryByPageSize(lastFetchMills);

        log.info("{}", JobCounter.state());
    }

    private void queryByPageSize(long lastFetchMills) {
        List<JobPersistentObject> jobs = longTermJobRepository.query(lastFetchMills, properties.getLongTermFetchPageSize());

        if (log.isDebugEnabled()) {
            log.debug("获取到[{}]之前的任务数量：{}", lastFetchMills, jobs.size());
        }

        recentJobRepository.pushAll(jobs);

        if (jobs.size() == properties.getLongTermFetchPageSize()) {
            queryByPageSize(lastFetchMills);
        }
    }
}
