package com.bxm.component.oncejob.bootstrap;

import com.bxm.component.oncejob.config.ComponentOnceJobConfigurationProperties;
import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.Date;
import java.util.List;

/**
 * 预加载定时任务
 *
 * @author liujia
 * @date 7/29/21 8:08 PM
 **/
@AllArgsConstructor
@Slf4j
public class FetchRecentJobRunner implements Runnable {

    private RecentJobRepository recentJobRepository;

    private ComponentOnceJobConfigurationProperties properties;

    @Override
    public void run() {
        long fixFetchMills = (System.currentTimeMillis() / properties.getFetchIntervalMills() + 1) * properties.getFetchIntervalMills();

        try {
            List<JobPersistentObject> persistentObjects = recentJobRepository.load(fixFetchMills, properties.getMaxFetchNum());

            if (log.isDebugEnabled()) {
                log.debug("预拉取定时任务，拉取数量：{},拉取时间：{}", persistentObjects.size(), fixFetchMills);
            }

            if (persistentObjects.size() > 0) {
                // 将任务放到本地队列
                for (JobPersistentObject persistentObject : persistentObjects) {
                    JobHolder.pushJob(persistentObject);
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        long fixFetchMills = (System.currentTimeMillis() / 5000 + 1) * 5000;
        System.out.println(DateUtils.formatDateTime(new Date(fixFetchMills)));
        System.out.println(fixFetchMills / 5000);
    }
}
