package com.bxm.component.oncejob.enums;

/**
 * 任务处理状态枚举
 *
 * @author liujia
 * @date 8/25/21 1:49 PM
 **/
public enum JobStatusEnum {
    /**
     * 未到期，等待执行
     */
    WAIT(0),

    /**
     * 正在处理中
     */
    RUNNING(1),

    /**
     * 执行完成，已关闭
     */
    CLOSE(2),

    /**
     * 已过期，未执行
     */
    EXPIRED(3),

    ;

    private int code;

    JobStatusEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }
}
