package com.bxm.component.oncejob.storage;

import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.job.OnceJobDefinition;

import java.util.List;

/**
 * 任务存储和调取相关的接口
 *
 * @author liujia
 * @date 7/29/21 5:24 PM
 **/
public interface JobRepository {

    /**
     * 保存任务信息
     *
     * @param definition 一次性任务的定义
     * @return 任务ID
     */
    String saveJob(OnceJobDefinition definition);

    /**
     * 移除调度任务
     *
     * @param jobId 任务ID
     * @return 是否移除成功
     */
    boolean removeJob(String jobId);

    /**
     * 清理脏数据，定期清理
     */
    List<JobPersistentObject> clearDirty();
}
