package com.bxm.component.oncejob.storage;

import com.bxm.component.oncejob.job.JobPersistentObject;

import java.util.List;

/**
 * 在较远时间之后才会被执行的任务
 *
 * @author liujia
 * @date 7/29/21 5:07 PM
 **/
public interface LongTermJobRepository extends JobRepository {

    /**
     * 查询即将执行的调度任务，获取在lastFireTimeMills之前执行的任务
     *
     * @param lastFireTimeMills 调度任务执行时间点
     * @param num               拉取的数量
     * @return 调度任务信息
     */
    List<JobPersistentObject> query(long lastFireTimeMills, int num);
}
