package com.bxm.component.oncejob.storage.memory;

import com.bxm.component.oncejob.job.JobPersistentObject;
import com.bxm.component.oncejob.job.OnceJobDefinition;
import com.bxm.component.oncejob.storage.LongTermJobRepository;
import com.bxm.component.oncejob.storage.RecentJobRepository;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * 基于内存实现的长期任务配置
 * 提供空实现，主要是用来做测试
 *
 * @author liujia
 * @date 8/2/21 3:55 PM
 **/
@AllArgsConstructor
@Slf4j
public class MemoryLongTermJobRepositoryImpl implements LongTermJobRepository {

    private RecentJobRepository recentJobRepository;

    @Override
    public String saveJob(OnceJobDefinition definition) {
        log.debug("添加一个长期任务：{}", definition);
        return recentJobRepository.saveJob(definition);
    }

    @Override
    public boolean removeJob(String jobId) {
        return false;
    }

    @Override
    public List<JobPersistentObject> clearDirty() {
        return Lists.newArrayList();
    }

    @Override
    public List<JobPersistentObject> query(long lastFireTimeMills, int num) {
        return Lists.newArrayList();
    }
}
