package com.bxm.newidea.component.oss.service;

import java.io.*;

import org.springframework.web.multipart.MultipartFile;

/**
 * @author: zhaoyadong 2018/9/13 17:10
 */
public interface AliyunOSSService {

    /**
     * 功能说明：文件名如果存在则会覆盖以前的文件<br/>
     * 多文件上传到OSS
     * @param multipartFiles   上传路径系统自定义 multipartFile.getOriginalFilename();
     *                                       根据multipartFile的后缀名来匹配上传路径
     *                                       例如：获取到的文件名称为：xxx.txt--- 上传路径为：/txt/yyyyMMdd/xxx.txt
     * @return 上上传成功返回所有链接地址的数组
     */
    String[] upload(MultipartFile... multipartFiles);

    /**
     * 功能说明：文件名如果存在则会覆盖以前的文件<br/>
     * 多文件上传到OSS.
     * @param files   上传路径系统自定义 file.getOriginalFilename();
     *                                       根据file的后缀名来匹配上传路径
     *                                       例如：获取到的文件名称为：xxx.txt--- 上传路径为：/txt/yyyyMMdd/xxx.txt
     * @return 上上传成功返回所有链接地址的数组
     */
    String[] upload(File... files);

    /**
     * 上传file到OSS.<br/>
     * @param file 本地文件
     * @param path
     *        文件上传的根路径为folder(系统自定义)
     *        上传文件的路径定义：/文件后缀名/日期(yyyyMMdd)/文件名
     *        path说明：1、为空：文件名为file.getName(); 根据file的后缀名来匹配上传路径
     *                        例如：file的路径为：D:/xxx.txt---上传的文件路径名为：/txt/yyyyMMdd/xxx.txt
     *                 2、不为空：
     *                          1、path是文件名(不包含路径,文件名以path的文件名为主)：创建目录
     *                            例如：file的路径为：D:/xxx.txt；path的文件名为：path.txt；
     *                                            上传的文件路径名为：/txt/yyyyMMdd/path.txt)
     *                          2、path是目录：例如：path的路径为：/test/   file的路径为：D:/xxx.txt；随机生成文件名：
     *                                           上传的文件路径名为： /txt/yyyyMMdd/test/UUID.txt)
     *                          3、path是全路径：例如：/txt/yyyyMMdd/xxx.txt：不做处理
     * <br/>
     * @return 上传成功返回链接地址，上传失败返回为null
     * @throws FileNotFoundException
     * @throws IOException
     */
    String upload(File file, String path);

    /**
     * 功能说明：文件名如果存在则会覆盖以前的文件<br/>
     * 上传Object到OSS.<br/>
     * @param data	字节数组数据
     * @param path 文件上传的根路径为folder(系统自定义)
     *             上传文件的路径定义：/文件后缀名/日期(yyyyMMdd)/文件名
     *             path说明：1、为空：自定义生成文件名并默认是txt类型--来匹配项目路径
     *                             例如：上传的文件路径名为：/txt/yyyyMMdd/UUID
     *                      2、不为空：(如果path为"/", 上传路径为/txt/yyyyMMdd/UUID)
     *                               1、path是文件名(不包含路径,文件名以path的文件名为主): 创建目录
     *                                 例如：path的名称为: xxx.txt----上传的文件路径名为：/txt/yyyyMMdd/xxx.txt)
     *                               2、path是目录（文件默认是txt类型--来匹配项目路径）：
     *                                           例如：path的路径为：/test/   上传的文件路径名为： /test/UUID.txt)
     *                               3、path是全路径：例如：/txt/yyyyMMdd/xxx.txt：不做处理
     * <br/>
     * @return 上传成功返回链接地址，上传失败返回为null
     * @throws FileNotFoundException
     * @throws IOException
     */
    String upload(byte[] data, String path);

    /**
     * 下载阿里云的文件.<br/>
     * @param path 阿里云文件路径
     *             下载文件的后缀名为开头：
     *             例如 下载的地址为:https://bxm-news.oss-cn-hangzhou.aliyuncs.com/localnews_test/txt/yyyyMMdd/xxx.txt
     *                            path则为：/txt/yyyyMMdd/xxx.txt
     * <br/>
     * @param filePath 本地文件路径
     * @return
     */
    Boolean download(String path, String filePath);

    String getOSSFileRoot();
}
