/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.oss.service.impl;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.oss.config.AliyunOssProperties;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.tools.UUIDUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class AliyunOSSServiceImpl
implements AliyunOSSService {
    private static final Logger log = LoggerFactory.getLogger(AliyunOSSService.class);
    private static final String separator = "/";
    private AliyunOssProperties aliyunOssProperties;

    @Autowired
    public AliyunOSSServiceImpl(AliyunOssProperties aliyunOssProperties) {
        this.aliyunOssProperties = aliyunOssProperties;
    }

    @Override
    public String getOSSFileRoot() {
        return "https://" + this.aliyunOssProperties.getBucket() + "." + this.aliyunOssProperties.getEndpoint() + separator + this.aliyunOssProperties.getFolder() + separator;
    }

    @Override
    public String[] upload(MultipartFile ... multipartFiles) {
        String[] strings = new String[multipartFiles.length];
        try {
            int i = 0;
            for (MultipartFile multipartFile : multipartFiles) {
                String fileName = multipartFile.getOriginalFilename();
                long contentLength = multipartFile.getSize();
                String contentType = multipartFile.getContentType();
                if (StringUtils.isBlank((CharSequence)contentType)) {
                    contentType = "text/plain";
                }
                String ossPath = this.generateOssPathByFile(fileName);
                PutObjectResult result = this.upload(multipartFile.getInputStream(), contentLength, contentType, ossPath);
                strings[i++] = this.getOSSFileRoot() + ossPath;
            }
        }
        catch (IOException e) {
            log.error("upload multipartFiles error," + e.getMessage(), (Throwable)e);
        }
        return strings;
    }

    @Override
    public String upload(MultipartFile multipartFile) {
        return this.upload(new MultipartFile[]{multipartFile})[0];
    }

    @Override
    public String upload(MultipartFile multipartFile, String path) {
        try {
            long contentLength = multipartFile.getSize();
            String contentType = multipartFile.getContentType();
            if (StringUtils.isBlank((CharSequence)contentType)) {
                contentType = "text/plain";
            }
            String ossPath = this.generateOssPath(path, multipartFile.getOriginalFilename());
            PutObjectResult result = this.upload(multipartFile.getInputStream(), contentLength, contentType, ossPath);
            return this.getOSSFileRoot() + ossPath;
        }
        catch (Exception e) {
            log.error("upload file error:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] upload(File ... files) {
        String[] uploadUrlArray = new String[files.length];
        try {
            int i = 0;
            for (File file : files) {
                long contentLength = file.length();
                String suffix = FileUtils.getFileExtension((File)file);
                String contentType = FileTypeEnum.getContentType((String)suffix);
                if (StringUtils.isBlank((CharSequence)contentType)) {
                    contentType = "text/plain";
                }
                String fileName = file.getName();
                String ossPath = this.generateOssPathByFile(fileName);
                PutObjectResult result = this.upload(new FileInputStream(file), contentLength, contentType, ossPath);
                uploadUrlArray[i++] = this.getOSSFileRoot() + ossPath;
            }
        }
        catch (IOException e) {
            log.error("upload files error", (Throwable)e);
        }
        return uploadUrlArray;
    }

    @Override
    public String upload(File file, String path) {
        try {
            long contentLength = file.length();
            String suffix = FileUtils.getFileExtension((File)file);
            String contentType = FileTypeEnum.getContentType((String)suffix);
            if (StringUtils.isBlank((CharSequence)contentType)) {
                contentType = "text/plain";
            }
            String ossPath = this.generateOssPath(path, file.getName());
            PutObjectResult result = this.upload(new FileInputStream(file), contentLength, contentType, ossPath);
            return this.getOSSFileRoot() + ossPath;
        }
        catch (Exception e) {
            log.error("upload file error:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String upload(InputStream stream, String path) {
        OSSClient client = this.getOssClient();
        String ossFilePath = this.generateOssPathByPath(path);
        PutObjectResult result = client.putObject(this.aliyunOssProperties.getBucket(), ossFilePath, stream);
        client.shutdown();
        return this.getOSSFileRoot() + ossFilePath;
    }

    @Override
    public String upload(byte[] data, String path) {
        try {
            long contentLength = data.length;
            String contentType = FileTypeEnum.getContentType((String)StringUtils.substringAfterLast((String)path, (String)"."));
            if (StringUtils.isBlank((CharSequence)contentType)) {
                contentType = "text/plain";
            }
            String ossPath = this.generateOssPathByPath(path);
            PutObjectResult result = this.upload(new ByteArrayInputStream(data), contentLength, contentType, ossPath);
            return this.getOSSFileRoot() + ossPath;
        }
        catch (Exception e) {
            log.error("\u5b57\u8282\u6d41\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Boolean download(String path, String filePath) {
        try {
            OSSClient ossClient = this.getOssClient();
            if (path.startsWith(separator)) {
                path = path.substring(1);
            }
            path = this.aliyunOssProperties.getFolder() + separator + path;
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.aliyunOssProperties.getBucket(), path);
            ossClient.getObject(getObjectRequest, new File(filePath));
            ossClient.shutdown();
            return true;
        }
        catch (Exception e) {
            log.error("download error", (Throwable)e);
            return false;
        }
    }

    private String generateOssPathByPath(String path) {
        String fileName = this.generateFileNameByPath(path);
        return this.generateOssPath(path, fileName);
    }

    private String generateOssPathByFile(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = UUIDUtils.nextID();
        }
        return this.generateOssPath(null, fileName);
    }

    private String generateOssPath(String path, String fileName) {
        if (StringUtils.isBlank((CharSequence)(path = this.handlePath(path)))) {
            path = this.generateDirByFileName(fileName).append(fileName).toString();
            return path;
        }
        if (!path.contains(separator)) {
            path = this.generateDirByFileName(fileName).append(path).toString();
            return path;
        }
        if (path.endsWith(separator)) {
            String suffix = this.generateSuffix(fileName);
            path = path + UUIDUtils.nextID() + "." + suffix;
            return path;
        }
        return path;
    }

    private String handlePath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return path;
        }
        if ((path = path.replaceAll("\\\\", separator)).startsWith(separator)) {
            path = path.substring(1);
        }
        return path;
    }

    private String generateFileNameByPath(String path) {
        if (StringUtils.isBlank((CharSequence)(path = this.handlePath(path)))) {
            return UUIDUtils.nextID();
        }
        if (!path.contains(separator)) {
            return path;
        }
        if (path.endsWith(separator)) {
            return UUIDUtils.nextID();
        }
        return StringUtils.substringAfterLast((String)path, (String)separator);
    }

    private StringBuilder generateDirByFileName(String fileName) {
        String suffix = this.generateSuffix(fileName);
        String todayStr = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
        return new StringBuilder().append(suffix).append(separator).append(todayStr).append(separator);
    }

    private String generateSuffix(String fileName) {
        String suffix = FileUtils.getFilextension((String)fileName);
        String contentType = FileTypeEnum.getContentType((String)suffix);
        if (StringUtils.isBlank((CharSequence)contentType)) {
            suffix = "txt";
        }
        return suffix;
    }

    private OSSClient getOssClient() {
        return new OSSClient(this.aliyunOssProperties.getEndpoint(), this.aliyunOssProperties.getAccessKey(), this.aliyunOssProperties.getAccessSecret());
    }

    private PutObjectResult upload(InputStream inputStream, long contentLength, String contentType, String path) {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(contentLength);
            meta.setContentType(contentType);
            OSSClient ossClient = this.getOssClient();
            path = this.aliyunOssProperties.getFolder() + separator + path;
            PutObjectResult result = ossClient.putObject(this.aliyunOssProperties.getBucket(), path, inputStream, meta);
            ossClient.shutdown();
            PutObjectResult putObjectResult = result;
            return putObjectResult;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

