package com.bxm.newidea.component.oss.service.impl;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.bxm.newidea.component.oss.config.AliyunOssTokenProperties;
import com.bxm.newidea.component.oss.dto.OSSToken;
import com.bxm.newidea.component.oss.service.AliyunOssTokenService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/4/9 15:16
 * @desc
 */
@Component("aliyunOssTokenService")
public class AliyunOssTokenServiceImpl implements AliyunOssTokenService {

    private final static Logger logger = LoggerFactory.getLogger(AliyunOssTokenServiceImpl.class);

    private AliyunOssTokenProperties aliyunOssTokenProperties;

    @Autowired
    public AliyunOssTokenServiceImpl(AliyunOssTokenProperties aliyunOssTokenProperties) {
        this.aliyunOssTokenProperties = aliyunOssTokenProperties;
    }

    @Override
    public OSSToken getOssToken() {
        try {
            AssumeRoleResponse response = getDafaultAcsClient().getAcsResponse(assumeRole());
            return new OSSToken(response.getCredentials().getSecurityToken(),
                    response.getCredentials().getAccessKeySecret(), response.getCredentials().getAccessKeyId());
        } catch (ClientException e) {
            logger.error("获取oss。。。token错误", e);
        }
        return null;
    }

    /**
     * 设置请求
     *
     * @return
     */
    private AssumeRoleRequest assumeRole() {
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.setVersion(aliyunOssTokenProperties.getStsApiVersion());
        request.setMethod(MethodType.POST);
        request.setProtocol(ProtocolType.HTTPS);

        request.setRoleArn(aliyunOssTokenProperties.getRoleArn());
        request.setRoleSessionName(aliyunOssTokenProperties.getRoleSessionName());
        request.setPolicy(aliyunOssTokenProperties.getPolicy());
        request.setDurationSeconds(Long.valueOf(aliyunOssTokenProperties.getTokenExpireTime()));

        return request;
    }

    /**
     * 获取oss实例
     *
     * @return
     */
    private DefaultAcsClient getDafaultAcsClient() {
        IClientProfile profile = DefaultProfile.getProfile(this.aliyunOssTokenProperties.getRegion(),
                this.aliyunOssTokenProperties.getAccessKey(),
                this.aliyunOssTokenProperties.getAccessSecret());
        return new DefaultAcsClient(profile);
    }
}
