package com.bxm.newidea.component.payment.service.impl;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.bxm.newidea.component.payment.constant.PaymentConstant;
import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.AlipayRefundRequest;
import com.bxm.newidea.component.payment.response.AlipayRefundResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import static java.math.RoundingMode.HALF_DOWN;

/**
 * 支付宝退款处理流程
 *
 * @author liujia
 * @date 2020-06-30 21:37
 **/
@Component
@Slf4j
public class AlipayRefundAction extends BasePaymentAction implements IPaymentAction<AlipayRefundRequest, AlipayRefundResponse> {

    @Override
    public AlipayRefundResponse exec(AlipayRefundRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("申请支付宝退款参数：{}", request);
        }

        AlipayClient alipayClient = configContext.obtainAlipayClient(request.getScene());

        if (alipayClient == null) {
            return null;
        }

        AlipayTradeRefundModel model = new AlipayTradeRefundModel();
        model.setTradeNo(request.getTradeNo());
        model.setOutRequestNo(request.getOutRefundNo());
        model.setRefundAmount(NumberUtils.format(request.getAmount().setScale(2, HALF_DOWN).floatValue()));
        model.setRefundReason(request.getRefundReason());

        AlipayTradeRefundRequest tradeRefundRequest = new AlipayTradeRefundRequest();
        tradeRefundRequest.setBizModel(model);


        try {
            AlipayTradeRefundResponse response = alipayClient.execute(tradeRefundRequest);

            AlipayRefundResponse refundResponse = new AlipayRefundResponse();
            refundResponse.setResponse(response);
            refundResponse.setRefundResult(StringUtils.equals(response.getCode(), PaymentConstant.ALIPAY_SUCCESS_CODE));

            return refundResponse;
        } catch (AlipayApiException e) {
            log.error("支付宝申请退款失败，请求参数：{}", request);
            log.error(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.ALIPAY;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.REFUND;
    }
}
