package com.bxm.newidea.component.payment.request;

import com.bxm.newidea.component.payment.response.WechatH5PreOrderResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * H5发起预支付请求
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class WechatH5PreOrderRequest extends PaymentRequest<WechatH5PreOrderResponse> {

    /**
     * 订单编号
     */
    private String orderNum;

    /**
     * 订单描述
     */
    private String orderDescription;

    /**
     * 订单付款金额
     */
    private BigDecimal amount;

    /**
     * 请求来源IP
     */
    private String requestIp;
}
