package com.bxm.newidea.component.payment.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import lombok.*;

import java.util.Map;

/**
 * @author zhaoyadong 2019/3/11 20:20
 * @desc
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
@XStreamAlias("xml")
public class WxPayWithdrawRequest extends BaseWxPayRequest {

    /**
     * 商户账号appid
     */
    @XStreamAlias("mch_appid")
    private String mchAppid;

    @XStreamAlias("mchid")
    private String mchId;

    /**
     * 设备信息
     * 微信支付分配的终端设备号
     */
    @XStreamAlias("device_info")
    private String deviceInfo;

    /**
     * 商户订单号
     * 商户订单号，需保持唯一性
     * (只能是字母或者数字，不能包含有其他字符)
     */
    @XStreamAlias("partner_trade_no")
    private String partnerTradeNo;

    /**
     * 用户openid
     * 商户appid下，某用户的openid
     */
    @XStreamAlias("openid")
    private String openId;

    /**
     * 校验用户姓名选项
     * NO_CHECK：不校验真实姓名
     * FORCE_CHECK：强校验真实姓名
     */
    @XStreamAlias("check_name")
    private String checkName;

    /**
     * 收款用户姓名
     * 收款用户真实姓名。
     * 如果check_name设置为FORCE_CHECK，则必填用户真实姓名
     */
    @XStreamAlias("re_user_name")
    private String reUserName;

    /**
     * 金额
     * 企业付款金额，单位为分
     */
    @XStreamAlias("amount")
    private Integer amount;

    /**
     * 企业付款备注，必填。
     * 注意：备注中的敏感词会被转成字符*
     */
    @XStreamAlias("desc")
    private String desc;

    /**
     * Ip地址
     * 该IP同在商户平台设置的IP白名单中的IP没有关联，该IP可传用户端或者服务端的IP。
     */
    @XStreamAlias("spbill_create_ip")
    private String spbillCreateIp;

    @Override
    protected String[] getIgnoredParamsForSign() {
        return new String[]{"sign_type"};
    }

    @Override
    protected void storeMap(Map<String, String> map) {

    }

    @Override
    protected void checkConstraints() {

    }

    @Override
    public String getAppid() {
        return this.mchAppid;
    }

    @Override
    public void setAppid(String appid) {
        this.mchAppid = appid;
    }
}
