package com.bxm.newidea.component.payment.config;

import lombok.Data;

/**
 * 支付宝商户号
 **/
@Data
public class AlipayMchAccount {

    /**
     * 商户号描述信息
     */
    private String description;

    /**
     * 商户号ID
     */
    private String mchId;

    /**
     * 商户号私钥（通过工具生成）
     */
    private String privateKey;

    /**
     * 支付宝公钥（通过上传工具生成的公钥后，支付平台提供的公钥，注意不是与私钥配对的公钥）
     */
    private String publicKey;

    /**
     * 支付宝商户号下申请的应用ID
     */
    private String appId;

    /**
     * 签名类型,默认RSA2
     */
    private String signType = "RSA2";

    /**
     * 字符编码
     */
    private String charset = "UTF-8";

    /**
     * 支付请求的网关地址
     */
    private String gateWayUrl = "https://openapi.alipay.com/gateway.do";

    /**
     * 格式化
     */
    private String format = "JSON";

    /**
     * 支付回调是否进行检查
     */
    private Boolean enableCheck = Boolean.TRUE;
}