package com.bxm.newidea.component.payment.request;

import com.bxm.newidea.component.payment.response.AlipayH5PreOrderResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * 支付宝H5支付订单请求
 *
 * @author liujia
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class AlipayH5PreOrderRequest extends PaymentRequest<AlipayH5PreOrderResponse> {

    /**
     * 订单编号
     */
    private String orderNum;

    /**
     * 订单显示的商品名称
     */
    private String orderTitle;

    /**
     * 订单描述，用户看到的商品描述
     */
    private String orderDescription;

    /**
     * 支付金额（单位：元）
     */
    private BigDecimal amount;

    /**
     * 支付超时时间，默认：5m (5分钟)
     */
    private String timeoutExpress = "5m";

    /**
     * 支付成功后的回调地址
     */
    private String notifyUrl;

    /**
     * 支付成功后的退回地址
     */
    private String returnUrl;
}
