package com.bxm.newidea.component.payment.request;

import com.bxm.newidea.component.payment.response.AlipayRefundResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * 支付宝退款申请参数
 *
 * @author liujia
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class AlipayRefundRequest extends PaymentRequest<AlipayRefundResponse> {

    /**
     * 交易编号
     */
    private String tradeNo;

    /**
     * 我方定义的退款流水编号，相同支付订单的退款申请单号需要保持一致
     */
    private String outRefundNo;

    /**
     * 退款金额
     */
    private BigDecimal amount;

    /**
     * 退款原因
     */
    private String refundReason;
}
