package com.bxm.newidea.component.payment.request;

import com.bxm.newidea.component.payment.response.WechatJsapiPreOrderPaymentResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * 微信发起预支付订单
 *
 * @author liujia
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper = true)
public class WechatJsapiPreOrderPaymentRequest extends PaymentRequest<WechatJsapiPreOrderPaymentResponse> {

    /**
     * 我方订单编号
     */
    private String orderNum;

    /**
     * 订单内容描述
     */
    private String orderDescription;

    /**
     * 下单金额（单位：元）
     */
    private BigDecimal amount;

    /**
     * 请求来源的IP
     */
    private String requestIp;

    /**
     * 微信授权编码，授权的公众号必须与对应的商户号有绑定关系
     */
    private String wxMpAuthCode;
}
