package com.bxm.newidea.component.payment.service.impl;

import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentModeEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.WechatH5PreOrderRequest;
import com.bxm.newidea.component.payment.response.WechatH5PreOrderResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.constant.WxPayConstants;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 微信发起H5预支付订单
 */
@Component
@Slf4j
public class WechatH5PreOrderAction extends BasePaymentAction implements IPaymentAction<WechatH5PreOrderRequest, WechatH5PreOrderResponse> {

    @SuppressWarnings("Duplicates")
    @Override
    public WechatH5PreOrderResponse exec(WechatH5PreOrderRequest request) {
        WxPayService wxPayService = configContext.obtainWxPayService(request.getScene());

        if (wxPayService == null) {
            return null;
        }

        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();

        wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
        wxPayUnifiedOrderRequest.setOutTradeNo(request.getOrderNum());
        wxPayUnifiedOrderRequest.setBody(request.getOrderDescription());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen(request.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(request.getRequestIp());
        wxPayUnifiedOrderRequest.setTradeType(WxPayConstants.TradeType.MWEB);

        try {
            WxPayMwebOrderResult result = wxPayService.createOrder(wxPayUnifiedOrderRequest);

            WechatH5PreOrderResponse response = new WechatH5PreOrderResponse();
            response.setPaymentLink(result.getMwebUrl());
            return response;
        } catch (WxPayException e) {
            log.error("创建H5预支付订单失败，请求参数为：{}", request);
            log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.WECHAT;
    }

    @Override
    public PaymentModeEnum matchMode() {
        return PaymentModeEnum.H5;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }
}
