package com.bxm.newidea.component.payment.service.impl;

import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.WechatPaymentCallbackRequest;
import com.bxm.newidea.component.payment.response.WechatPaymentCallbackResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.service.WxPayService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import static com.bxm.newidea.component.payment.constant.PaymentConstant.WECHAT_SUCCSS_CODE;

/**
 * 微信支付成功的回调处理，各种支付模式的回调逻辑均一致
 *
 * @author liujia
 */
@Component
@Slf4j
public class WechatPaymentCallbackAction extends BasePaymentAction implements IPaymentAction<WechatPaymentCallbackRequest, WechatPaymentCallbackResponse> {

    @Override
    public WechatPaymentCallbackResponse exec(WechatPaymentCallbackRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("微信支付结果回调，请求参数为：{}", request);
        }

        try {
            // 解析响应数据，如果无法解析则直接返回null
            WxPayOrderNotifyResult preParseResult = WxPayOrderNotifyResult.fromXML(request.getCallbackData());

            //判断支付是否成功
            if (WECHAT_SUCCSS_CODE.equals(preParseResult.getReturnCode())
                    && WECHAT_SUCCSS_CODE.equals(preParseResult.getResultCode())) {
                //根据商户号获取微信支付服务实例
                String mchId = preParseResult.getMchId();

                WxPayService wxPayService = configContext.obtainWxPayServiceByMchId(mchId);

                if (null != wxPayService) {
                    WxPayOrderNotifyResult result = wxPayService.parseOrderNotifyResult(request.getCallbackData());

                    WechatPaymentCallbackResponse response = new WechatPaymentCallbackResponse();
                    response.setResult(result);
                    response.setSuccess(Boolean.TRUE);

                    return response;
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            log.error("支付结果无法解析为对应的格式,请求参数为：{}", request);
        }
        return null;
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.WECHAT;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.PAYMENT_CALLBACK;
    }
}
