/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.payment.service.impl;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentModeEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.AlipayH5PreOrderRequest;
import com.bxm.newidea.component.payment.response.AlipayH5PreOrderResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.bxm.newidea.component.payment.service.impl.BasePaymentAction;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlipayH5PreOrderAction
extends BasePaymentAction
implements IPaymentAction<AlipayH5PreOrderRequest, AlipayH5PreOrderResponse> {
    private static final Logger log = LoggerFactory.getLogger(AlipayH5PreOrderAction.class);

    @Override
    public AlipayH5PreOrderResponse exec(AlipayH5PreOrderRequest request) {
        AlipayClient alipayClient;
        if (log.isDebugEnabled()) {
            log.debug("\u53d1\u8d77\u652f\u4ed8\u5b9d\u9884\u652f\u4ed8\u8bf7\u6c42\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)request);
        }
        if ((alipayClient = this.configContext.obtainAlipayClient(request.getScene())) == null) {
            return null;
        }
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        alipayRequest.setBizModel((AlipayObject)this.createWapPayModel(request));
        alipayRequest.setNotifyUrl(request.getNotifyUrl());
        if (StringUtils.isNotBlank((String)request.getReturnUrl())) {
            String returnUrl = request.getReturnUrl() + "&paymentNum=paymentOrderDetail.getPaymentNum()";
            alipayRequest.setReturnUrl(returnUrl);
        }
        try {
            AlipayResponse alipayResponse = alipayClient.execute((AlipayRequest)alipayRequest);
            AlipayH5PreOrderResponse response = new AlipayH5PreOrderResponse();
            response.setLink(alipayResponse.getBody());
            return response;
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u53d1\u8d77\u9884\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)request);
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private AlipayTradeWapPayModel createWapPayModel(AlipayH5PreOrderRequest request) {
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(request.getOrderNum());
        model.setTotalAmount(request.getAmount().toString());
        model.setSubject(request.getOrderTitle());
        model.setBody(request.getOrderDescription());
        model.setProductCode("QUICK_WAP_WAY");
        model.setTimeoutExpress(request.getTimeoutExpress());
        return model;
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.ALIPAY;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }

    @Override
    public PaymentModeEnum matchMode() {
        return PaymentModeEnum.H5;
    }
}

