package com.bxm.newidea.component.payment.request;

import com.bxm.newidea.component.payment.response.AlipayPaymentCallbackResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 支付宝支付回调处理
 *
 * @author liujia
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class AlipanyPaymentCallbackRequest extends PaymentRequest<AlipayPaymentCallbackResponse> {

    /**
     * 回调的原始请求参数
     */
    private HttpServletRequest request;

    /**
     * 回调的原始响应参数
     */
    private HttpServletResponse response;
}
