package com.bxm.newidea.component.payment.service;

import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentModeEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.PaymentRequest;
import com.bxm.newidea.component.payment.response.PaymentResponse;

/**
 * 支付动作接口，根据不同的平台、支付模式与支付动作进行匹配
 */
public interface IPaymentAction<R extends PaymentRequest, T extends PaymentResponse> {

    /**
     * 执行具体的支付动作
     *
     * @param request 请求参数
     * @return 响应结果
     */
    T exec(R request);

    /**
     * 当前业务匹配的平台
     *
     * @return 当前实例支持的支付平台
     */
    PaymentPlatformEnum matchPlatform();

    /**
     * 当前业务匹配的支付模式（同一种支付模式，同一中支付动作，会存在不同的支付模式区别）
     *
     * @return 当前实例支持的支付模式
     */
    default PaymentModeEnum matchMode() {
        return PaymentModeEnum.COMMON;
    }

    /**
     * 当前业务支持的支付动作，对应支付流程中的不同环节
     *
     * @return 当前实例支持的支付动作
     */
    PaymentActionEnum matchAction();
}
