package com.bxm.component.poster.template.element;

import com.bxm.component.poster.context.PosterContext;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import lombok.Data;

import java.awt.*;
import java.io.IOException;

/**
 * 基础元素
 *
 * @author liujia
 * @date 12/17/20 10:51 AM
 **/
@Data
public abstract class AbstractElement {

    /**
     * 元素在画布上的X坐标
     * required : true
     */
    @XStreamAsAttribute
    private int x;

    /**
     * 元素在画布上的Y坐标
     * required : true
     */
    @XStreamAsAttribute
    private int y;

    /**
     * 元素的取值来源字段，从请求绘制的海报上下文中的扩展信息字段中获取
     * required : true
     */
    @XStreamAsAttribute
    private String field;

    /**
     * 渲染元素到画布上
     *
     * @param posterGraphics2D 图像操作对象
     * @param context          请求创建海报的上下文信息
     */
    public abstract void render(Graphics2D posterGraphics2D, PosterContext context) throws IOException;
}
