/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.poster.template.element;

import com.bxm.component.poster.context.PosterContext;
import com.bxm.component.poster.template.element.AbstractElement;
import com.bxm.component.poster.utils.FileLoadUtil;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageElement
extends AbstractElement {
    private static final Logger log = LoggerFactory.getLogger(ImageElement.class);
    @XStreamAsAttribute
    private int width;
    @XStreamAsAttribute
    private int height;
    @XStreamAsAttribute
    private Integer cornerRadius;

    @Override
    public void render(Graphics2D posterGraphics2D, PosterContext context) throws IOException {
        String imagePath = context.getValue(this.getField());
        InputStream inputStream = FileLoadUtil.load(imagePath, true);
        if (null == inputStream) {
            log.error("\u6e32\u67d3\u6d77\u62a5\u63d0\u4f9b\u7684\u56fe\u7247\u5730\u5740[{}]\u4e0d\u5b58\u5728", (Object)imagePath);
            return;
        }
        BufferedImage subImage = ImageIO.read(inputStream);
        if (this.cornerRadius != null) {
            subImage = this.makeRoundedCorner(subImage, this.cornerRadius);
        }
        posterGraphics2D.drawImage(subImage, this.getX(), this.getY(), this.width, this.height, null);
    }

    private BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius) {
        int cornerWidth = image.getWidth();
        int cornerHeight = image.getHeight();
        BufferedImage output = new BufferedImage(cornerWidth, cornerHeight, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, cornerWidth, cornerHeight, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return output;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageElement)) {
            return false;
        }
        ImageElement other = (ImageElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        Integer this$cornerRadius = this.getCornerRadius();
        Integer other$cornerRadius = other.getCornerRadius();
        return !(this$cornerRadius == null ? other$cornerRadius != null : !((Object)this$cornerRadius).equals(other$cornerRadius));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImageElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        Integer $cornerRadius = this.getCornerRadius();
        result = result * 59 + ($cornerRadius == null ? 43 : ((Object)$cornerRadius).hashCode());
        return result;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Integer getCornerRadius() {
        return this.cornerRadius;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setCornerRadius(Integer cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    @Override
    public String toString() {
        return "ImageElement(width=" + this.getWidth() + ", height=" + this.getHeight() + ", cornerRadius=" + this.getCornerRadius() + ")";
    }
}

