package com.bxm.component.poster.output.impl;

import com.bxm.component.poster.context.PosterContext;
import com.bxm.component.poster.output.IPosterOutput;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.IOException;

import static com.bxm.newidea.component.tools.FileUtils.getClassRootPath;

/**
 * 输出到本地目录
 *
 * @author liujia
 * @date 12/17/20 12:06 PM
 **/
@Slf4j
public class LocalPosterOutput implements IPosterOutput {

    @Override
    public String output(PosterContext context, File tempPoster) {
        File destFile = new File(buildFilePath(context));

        try {
            FileUtils.moveFile(tempPoster, destFile);
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        }

        return destFile.getAbsolutePath();
    }

    private String buildFilePath(PosterContext context) {
        String rootPath = getClassRootPath();
        String fileName = context.obtainUniqueKey();
        return rootPath + fileName + "." + context.getFileExtension();
    }

    @Override
    public String exists(PosterContext context) {
        String filePath = buildFilePath(context);

        if (new File(filePath).exists()) {
            return filePath;
        }
        return null;
    }
}
