/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.poster.template.element;

import com.bxm.component.poster.context.PosterContext;
import com.bxm.component.poster.template.element.AbstractElement;
import com.bxm.component.poster.template.extend.FontStyle;
import com.bxm.component.poster.utils.FontManage;
import com.bxm.newidea.component.tools.StringUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;

public class TextElement
extends AbstractElement {
    @XStreamAlias(value="font")
    private FontStyle fontStyle;
    @XStreamAsAttribute
    private Integer max;
    @XStreamAsAttribute
    private String replace;
    @XStreamAsAttribute
    private String color;
    @XStreamAsAttribute
    private Integer width;
    @XStreamAsAttribute
    private String align;
    @XStreamAsAttribute
    private Integer rightX;

    @Override
    public void render(Graphics2D posterGraphics2D, PosterContext context) {
        String content = context.getValue(this.getField());
        if (null != this.max && content.length() > this.getMax()) {
            content = StringUtils.substring((String)content, (int)0, (int)this.getMax());
            if (null != this.replace) {
                content = content + this.replace;
            }
        }
        this.setColor(posterGraphics2D);
        if (null == this.fontStyle) {
            this.fontStyle = new FontStyle();
            this.fontStyle.setStyle(0);
            this.fontStyle.setSize(20.0f);
        }
        Font font = FontManage.loadFont(this.fontStyle);
        posterGraphics2D.setFont(font);
        FontMetrics fontMetrics = posterGraphics2D.getFontMetrics(font);
        if (null != this.width) {
            this.drawMultiString(posterGraphics2D, fontMetrics, font, content);
        } else {
            this.drawString(posterGraphics2D, content, font, fontMetrics, 0);
        }
    }

    private void drawString(Graphics2D posterGraphics2D, String content, Font font, FontMetrics fontMetrics, int extHeight) {
        int floatXPoint = this.getX();
        if (this.align != null && this.rightX != null) {
            int innerWidth = this.rightX - this.getX();
            int contentWidth = fontMetrics.stringWidth(content);
            if ("CENTER".equalsIgnoreCase(this.align)) {
                if (contentWidth < innerWidth) {
                    floatXPoint += (innerWidth - contentWidth) / 2;
                }
            } else if ("RIGHT".equalsIgnoreCase(this.align)) {
                floatXPoint += innerWidth - contentWidth;
            }
        }
        posterGraphics2D.drawString(this.attributedString(content, font).getIterator(), floatXPoint, this.getY() + fontMetrics.getAscent() + extHeight);
    }

    private AttributedString attributedString(String content, Font font) {
        AttributedString attributedString = new AttributedString(content);
        attributedString.addAttribute(TextAttribute.FONT, font);
        this.fillTextAttribute(attributedString);
        return attributedString;
    }

    private void fillTextAttribute(AttributedString attributedString) {
        if (this.fontStyle == null) {
            return;
        }
        if (null != this.fontStyle.getLine()) {
            if ("STRIKETHROUGH".equalsIgnoreCase(this.fontStyle.getLine())) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            } else if ("UNDERLINE".equalsIgnoreCase(this.fontStyle.getLine())) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
        }
        if (null == this.fontStyle.getWeight() || "SEMIBOLD".equalsIgnoreCase(this.fontStyle.getWeight())) {
            attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_SEMIBOLD);
        }
    }

    private void setColor(Graphics2D posterGraphics2D) {
        String[] rgbColorArray;
        Color hsbColor = Color.BLACK;
        if (null != this.color && (rgbColorArray = StringUtils.split((String)this.color, (String)",")).length == 3) {
            hsbColor = new Color(NumberUtils.toInt((String)rgbColorArray[0]), NumberUtils.toInt((String)rgbColorArray[1]), NumberUtils.toInt((String)rgbColorArray[2]));
        }
        posterGraphics2D.setColor(hsbColor);
    }

    private void drawMultiString(Graphics2D graphics2D, FontMetrics fontMetrics, Font font, String text) {
        int x = this.getX();
        int y = this.getY();
        int widthLength = this.getWidth();
        int yn = fontMetrics.getHeight();
        ArrayList<String> contentCharList = new ArrayList<String>(text.length());
        this.getListText(fontMetrics, text, widthLength, contentCharList);
        for (int i = 0; i < contentCharList.size(); ++i) {
            this.drawString(graphics2D, (String)contentCharList.get(i), font, fontMetrics, i * yn);
        }
    }

    private void getListText(FontMetrics fontMetrics, String text, int widthLength, List<String> contentCharList) {
        String subStr = text;
        boolean breakFlag = true;
        int i = 1;
        while (breakFlag) {
            if (fontMetrics.stringWidth(text) > widthLength) {
                text = text.substring(0, text.length() - 1);
                ++i;
                continue;
            }
            breakFlag = false;
        }
        if (i != 1) {
            contentCharList.add(subStr.substring(0, subStr.length() - i));
            this.getListText(fontMetrics, subStr.substring(subStr.length() - i), widthLength, contentCharList);
        } else {
            contentCharList.add(text);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextElement)) {
            return false;
        }
        TextElement other = (TextElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FontStyle this$fontStyle = this.getFontStyle();
        FontStyle other$fontStyle = other.getFontStyle();
        if (this$fontStyle == null ? other$fontStyle != null : !((Object)this$fontStyle).equals(other$fontStyle)) {
            return false;
        }
        Integer this$max = this.getMax();
        Integer other$max = other.getMax();
        if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
            return false;
        }
        String this$replace = this.getReplace();
        String other$replace = other.getReplace();
        if (this$replace == null ? other$replace != null : !this$replace.equals(other$replace)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        String this$align = this.getAlign();
        String other$align = other.getAlign();
        if (this$align == null ? other$align != null : !this$align.equals(other$align)) {
            return false;
        }
        Integer this$rightX = this.getRightX();
        Integer other$rightX = other.getRightX();
        return !(this$rightX == null ? other$rightX != null : !((Object)this$rightX).equals(other$rightX));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        FontStyle $fontStyle = this.getFontStyle();
        result = result * 59 + ($fontStyle == null ? 43 : ((Object)$fontStyle).hashCode());
        Integer $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        String $replace = this.getReplace();
        result = result * 59 + ($replace == null ? 43 : $replace.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        String $align = this.getAlign();
        result = result * 59 + ($align == null ? 43 : $align.hashCode());
        Integer $rightX = this.getRightX();
        result = result * 59 + ($rightX == null ? 43 : ((Object)$rightX).hashCode());
        return result;
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public Integer getMax() {
        return this.max;
    }

    public String getReplace() {
        return this.replace;
    }

    public String getColor() {
        return this.color;
    }

    public Integer getWidth() {
        return this.width;
    }

    public String getAlign() {
        return this.align;
    }

    public Integer getRightX() {
        return this.rightX;
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public void setReplace(String replace) {
        this.replace = replace;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public void setRightX(Integer rightX) {
        this.rightX = rightX;
    }

    @Override
    public String toString() {
        return "TextElement(fontStyle=" + this.getFontStyle() + ", max=" + this.getMax() + ", replace=" + this.getReplace() + ", color=" + this.getColor() + ", width=" + this.getWidth() + ", align=" + this.getAlign() + ", rightX=" + this.getRightX() + ")";
    }
}

