/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.poster.template;

import com.bxm.component.poster.context.PosterContext;
import com.bxm.component.poster.template.element.AbstractElement;
import com.bxm.component.poster.template.element.CircularImageElement;
import com.bxm.component.poster.template.element.ImageElement;
import com.bxm.component.poster.template.element.QrcodeElement;
import com.bxm.component.poster.template.element.TextElement;
import com.bxm.component.poster.utils.FileLoadUtil;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.FileUtils;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="template")
public class PosterTemplate {
    private static final Logger log = LoggerFactory.getLogger(PosterTemplate.class);
    private List<AbstractElement> elements;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String backgroundImage;
    @XStreamImplicit(itemFieldName="text")
    private List<TextElement> textElements = Lists.newArrayList();
    @XStreamImplicit(itemFieldName="qrcode")
    private List<QrcodeElement> qrcodeElements = Lists.newArrayList();
    @XStreamImplicit(itemFieldName="image")
    private List<ImageElement> imageElements = Lists.newArrayList();
    @XStreamImplicit(itemFieldName="circular")
    private List<CircularImageElement> circularImageElements = Lists.newArrayList();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File render(PosterContext context) {
        String loadIamge = this.backgroundImage;
        if (null != context.getMainImage()) {
            loadIamge = context.getMainImage();
        }
        try (InputStream inputStream = FileLoadUtil.load(loadIamge, true);){
            if (inputStream == null) {
                File file2 = null;
                return file2;
            }
            BufferedImage backgroundImageBuffered = ImageIO.read(inputStream);
            Graphics2D posterGraphics2D = backgroundImageBuffered.createGraphics();
            posterGraphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            for (AbstractElement element : this.getAllElements()) {
                element.render(posterGraphics2D, context);
            }
            posterGraphics2D.dispose();
            String tempImgFileName = FileUtils.getClassRootPath() + File.separator + "temp/" + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()) + "/" + context.hashCode() + "." + context.getFileExtension();
            File tempImgFile = new File(tempImgFileName);
            FileUtils.checkAndCreateFile((File)tempImgFile);
            ImageIO.write((RenderedImage)backgroundImageBuffered, context.getFileExtension(), tempImgFile);
            File file = tempImgFile;
            return file;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{},\u5f53\u524d\u6a21\u677f\u914d\u7f6e\uff1a{}", (Object)context, (Object)this);
            return null;
        }
    }

    private List<AbstractElement> getAllElements() {
        if (this.elements == null) {
            this.elements = Lists.newArrayList();
            if (null != this.textElements) {
                this.elements.addAll(this.textElements);
            }
            if (null != this.qrcodeElements) {
                this.elements.addAll(this.qrcodeElements);
            }
            if (null != this.imageElements) {
                this.elements.addAll(this.imageElements);
            }
            if (null != this.circularImageElements) {
                this.elements.addAll(this.circularImageElements);
            }
        }
        return this.elements;
    }

    public List<AbstractElement> getElements() {
        return this.elements;
    }

    public String getName() {
        return this.name;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public List<TextElement> getTextElements() {
        return this.textElements;
    }

    public List<QrcodeElement> getQrcodeElements() {
        return this.qrcodeElements;
    }

    public List<ImageElement> getImageElements() {
        return this.imageElements;
    }

    public List<CircularImageElement> getCircularImageElements() {
        return this.circularImageElements;
    }

    public void setElements(List<AbstractElement> elements) {
        this.elements = elements;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public void setTextElements(List<TextElement> textElements) {
        this.textElements = textElements;
    }

    public void setQrcodeElements(List<QrcodeElement> qrcodeElements) {
        this.qrcodeElements = qrcodeElements;
    }

    public void setImageElements(List<ImageElement> imageElements) {
        this.imageElements = imageElements;
    }

    public void setCircularImageElements(List<CircularImageElement> circularImageElements) {
        this.circularImageElements = circularImageElements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PosterTemplate)) {
            return false;
        }
        PosterTemplate other = (PosterTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AbstractElement> this$elements = this.getElements();
        List<AbstractElement> other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$backgroundImage = this.getBackgroundImage();
        String other$backgroundImage = other.getBackgroundImage();
        if (this$backgroundImage == null ? other$backgroundImage != null : !this$backgroundImage.equals(other$backgroundImage)) {
            return false;
        }
        List<TextElement> this$textElements = this.getTextElements();
        List<TextElement> other$textElements = other.getTextElements();
        if (this$textElements == null ? other$textElements != null : !((Object)this$textElements).equals(other$textElements)) {
            return false;
        }
        List<QrcodeElement> this$qrcodeElements = this.getQrcodeElements();
        List<QrcodeElement> other$qrcodeElements = other.getQrcodeElements();
        if (this$qrcodeElements == null ? other$qrcodeElements != null : !((Object)this$qrcodeElements).equals(other$qrcodeElements)) {
            return false;
        }
        List<ImageElement> this$imageElements = this.getImageElements();
        List<ImageElement> other$imageElements = other.getImageElements();
        if (this$imageElements == null ? other$imageElements != null : !((Object)this$imageElements).equals(other$imageElements)) {
            return false;
        }
        List<CircularImageElement> this$circularImageElements = this.getCircularImageElements();
        List<CircularImageElement> other$circularImageElements = other.getCircularImageElements();
        return !(this$circularImageElements == null ? other$circularImageElements != null : !((Object)this$circularImageElements).equals(other$circularImageElements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PosterTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AbstractElement> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $backgroundImage = this.getBackgroundImage();
        result = result * 59 + ($backgroundImage == null ? 43 : $backgroundImage.hashCode());
        List<TextElement> $textElements = this.getTextElements();
        result = result * 59 + ($textElements == null ? 43 : ((Object)$textElements).hashCode());
        List<QrcodeElement> $qrcodeElements = this.getQrcodeElements();
        result = result * 59 + ($qrcodeElements == null ? 43 : ((Object)$qrcodeElements).hashCode());
        List<ImageElement> $imageElements = this.getImageElements();
        result = result * 59 + ($imageElements == null ? 43 : ((Object)$imageElements).hashCode());
        List<CircularImageElement> $circularImageElements = this.getCircularImageElements();
        result = result * 59 + ($circularImageElements == null ? 43 : ((Object)$circularImageElements).hashCode());
        return result;
    }

    public String toString() {
        return "PosterTemplate(elements=" + this.getElements() + ", name=" + this.getName() + ", backgroundImage=" + this.getBackgroundImage() + ", textElements=" + this.getTextElements() + ", qrcodeElements=" + this.getQrcodeElements() + ", imageElements=" + this.getImageElements() + ", circularImageElements=" + this.getCircularImageElements() + ")";
    }
}

