/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.poster.output.impl;

import com.bxm.component.poster.context.PosterContext;
import com.bxm.component.poster.output.IPosterOutput;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPosterOutput
implements IPosterOutput {
    private static final Logger log = LoggerFactory.getLogger(LocalPosterOutput.class);

    @Override
    public String output(PosterContext context, File tempPoster) {
        File destFile = new File(this.buildFilePath(context));
        try {
            FileUtils.moveFile((File)tempPoster, (File)destFile);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return destFile.getAbsolutePath();
    }

    @Override
    public void remove(PosterContext context) {
        String filePath = this.buildFilePath(context);
        File oldFile = new File(filePath);
        if (oldFile.exists() && !oldFile.delete()) {
            log.error("\u6587\u4ef6\u79fb\u9664\u5931\u8d25\uff0c\u6587\u4ef6\u5730\u5740\uff1a{}", (Object)filePath);
        }
    }

    private String buildFilePath(PosterContext context) {
        String rootPath = com.bxm.newidea.component.tools.FileUtils.getClassRootPath();
        String fileName = context.obtainUniqueKey();
        return rootPath + fileName + "." + context.getFileExtension();
    }

    @Override
    public String exists(PosterContext context) {
        String filePath = this.buildFilePath(context);
        if (new File(filePath).exists()) {
            return filePath;
        }
        return null;
    }
}

