package com.bxm.component.poster.output;

import com.bxm.component.poster.context.PosterContext;

import java.io.File;

/**
 * 海报生成后的输出策略
 *
 * @author liujia
 * @date 12/17/20 12:02 PM
 **/
public interface IPosterOutput {

    /**
     * 将海报文件二进制输出到目标地址
     *
     * @param context    创建海报的上下文
     * @param tempPoster 海报图片的临时存储
     * @return 存储地址
     */
    String output(PosterContext context, File tempPoster);

    /**
     * 移除输出的目标文件，当输出策略为覆盖时，用于移除旧文件
     *
     * @param context 创建海报的上下文
     */
    void remove(PosterContext context);

    /**
     * 判断文件是否存在，如果存在则直接返回文件地址
     * 用于判断是否需要重复生成
     *
     * @param context 海报生成上下文
     * @return 已经生成的海报地址
     */
    String exists(PosterContext context);
}
