package com.bxm.component.poster.output.impl;

import com.bxm.component.poster.context.PosterContext;
import com.bxm.component.poster.output.IPosterOutput;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;

/**
 * 将海报上传到阿里云oss文件存储
 *
 * @author liujia
 * @date 12/17/20 2:27 PM
 **/
@Component
public class AliyunOssOutput implements IPosterOutput {

    private AliyunOSSService aliyunOSSService;

    @Autowired
    public AliyunOssOutput(AliyunOSSService aliyunOSSService) {
        this.aliyunOSSService = aliyunOSSService;
    }

    @Override
    public String output(PosterContext context, File tempPoster) {
        String filePath = buildFilePath(context);

        return aliyunOSSService.upload(tempPoster, filePath, true);
    }

    @Override
    public void remove(PosterContext context) {
        // 支持覆盖，不需要主动输出
    }

    private String buildFilePath(PosterContext context) {
        String fileName = context.obtainUniqueKey();
        long subFolder = fileName.hashCode() % 1024;

        return "poster/" + subFolder + "/" + fileName + "." + context.getFileExtension();
    }

    @Override
    public String exists(PosterContext context) {
        String root = aliyunOSSService.getOSSFileRoot();
        String filePath = buildFilePath(context);

        if (aliyunOSSService.exists(filePath)) {
            return root + filePath;
        }
        return null;
    }
}
