package com.bxm.component.poster.utils;

import com.bxm.component.poster.template.PosterTemplate;
import com.thoughtworks.xstream.XStream;

/**
 * 将xml配置解析为海报模板
 *
 * @author liujia
 * @date 12/17/20 12:02 PM
 **/
public class XmlParser {

    private XmlParser() {
    }

    public static PosterTemplate parse(String xml) {
        XStream xStream = new XStream();

        xStream.processAnnotations(PosterTemplate.class);
        xStream.autodetectAnnotations(true);

        return (PosterTemplate) xStream.fromXML(xml);
    }
}
