/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.poster.output.impl;

import com.bxm.component.poster.context.PosterContext;
import com.bxm.component.poster.output.IPosterOutput;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliyunOssOutput
implements IPosterOutput {
    private AliyunOSSService aliyunOSSService;

    @Autowired
    public AliyunOssOutput(AliyunOSSService aliyunOSSService) {
        this.aliyunOSSService = aliyunOSSService;
    }

    @Override
    public String output(PosterContext context, File tempPoster) {
        String filePath = this.buildFilePath(context);
        return this.aliyunOSSService.upload(tempPoster, filePath, true);
    }

    @Override
    public void remove(PosterContext context) {
    }

    private String buildFilePath(PosterContext context) {
        String fileName = context.obtainUniqueKey();
        long subFolder = fileName.hashCode() % 1024;
        return "poster/" + subFolder + "/" + fileName + "." + context.getFileExtension();
    }

    @Override
    public String exists(PosterContext context) {
        String root = this.aliyunOSSService.getOSSFileRoot();
        String filePath = this.buildFilePath(context);
        if (this.aliyunOSSService.exists(filePath)) {
            return root + filePath;
        }
        return null;
    }
}

