/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.poster.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoadUtil {
    private static final Logger log = LoggerFactory.getLogger(FileLoadUtil.class);

    public static InputStream load(String filePath, boolean cache) {
        File loadFile = FileLoadUtil.loadFile(filePath, cache);
        if (null != loadFile) {
            if (!loadFile.canRead()) {
                log.error("\u6587\u4ef6[{}]\u4e0d\u53ef\u8bfb\u53d6\uff0c\u8bf7\u68c0\u67e5\u6743\u9650", (Object)loadFile.getAbsolutePath());
                return null;
            }
            if (!loadFile.exists()) {
                log.error("\u6587\u4ef6[{}]\u4e0d\u5b58\u5728", (Object)loadFile.getAbsolutePath());
                return null;
            }
            return new BufferedInputStream(new FileInputStream(loadFile));
        }
        return null;
    }

    private static String buildLocalPath(String remotePath) {
        boolean mkdir;
        File sysTempDir;
        String tempDir = System.getProperty("temp.dir");
        if (null == tempDir && StringUtils.isBlank((CharSequence)(tempDir = System.getProperty("java.io.tmpdir")))) {
            tempDir = "/opt/temp";
        }
        if (!(sysTempDir = new File(tempDir)).exists() && !(mkdir = sysTempDir.mkdirs())) {
            log.error("\u521b\u5efa\u4e34\u65f6\u76ee\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u95ee\u9898\uff0c\u76ee\u5f55\uff1a{}", (Object)sysTempDir);
        }
        if (!tempDir.endsWith("/")) {
            tempDir = tempDir + "/";
        }
        long hashCode = remotePath.hashCode() & Integer.MAX_VALUE;
        String fileExtension = FileUtils.getFilextension((String)remotePath);
        String finalFilePath = tempDir + "d" + hashCode % 100L + File.separator + "f" + hashCode + "." + fileExtension;
        if (log.isDebugEnabled()) {
            log.debug("\u6587\u4ef6\uff1a{}\u4e0b\u8f7d\u540e\u7684\u672c\u5730\u5b58\u50a8\u5730\u5740\uff1a{}", (Object)remotePath, (Object)finalFilePath);
        }
        return finalFilePath;
    }

    private static boolean isRemote(String filePath) {
        return StringUtils.startsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{"http:", "https:"});
    }

    public static File loadFile(String filePath, boolean cache) {
        File localFile;
        if (FileLoadUtil.isRemote(filePath)) {
            String localPath = FileLoadUtil.buildLocalPath(filePath);
            localFile = new File(localPath);
            if (cache && localFile.exists()) {
                log.info("\u52a0\u8f7d\u672c\u5730\u7f13\u5b58\u6587\u4ef6\uff1a{}", (Object)localPath);
                return localFile;
            }
            TimeInterval timer = DateUtil.timer();
            HttpUtil.downloadFile((String)filePath, (File)localFile);
            if (log.isDebugEnabled()) {
                log.debug("\u4e0b\u8f7d\u8017\u65f6\uff1a{}", (Object)timer.intervalMs());
            }
        } else {
            localFile = new File(filePath);
            if (!localFile.exists()) {
                return null;
            }
        }
        return localFile;
    }
}

