package com.bxm.component.poster.config;

import com.bxm.component.poster.template.PosterTemplate;
import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 海报模板的外部配置，可以选择通过apollo进行配置，也可以注入
 *
 * @author liujia
 * @date 12/17/20 11:06 AM
 **/
@Data
@Component
@ConfigurationProperties(prefix = "poster.config")
public class PosterConfigurationProperties {

    /**
     * 海报模板配置
     * key：海报别名
     * value：海报的详细配置
     */
    private Map<String, PosterTemplate> templateMap = Maps.newHashMap();

    /**
     * 延迟初始化相关资源
     */
    private boolean lazyInit = true;
}
