/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.poster.utils;

import com.bxm.component.poster.template.extend.FontStyle;
import com.bxm.component.poster.utils.FileLoadUtil;
import com.google.common.collect.Maps;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontManage {
    private static final Logger log = LoggerFactory.getLogger(FontManage.class);
    private static final Map<String, Font> FONT_MAP = Maps.newHashMap();
    private static final String DEFAULT_FONT = "default";
    private static final AtomicBoolean INIT_FLAG = new AtomicBoolean();

    private FontManage() {
    }

    public static void init() {
        if (INIT_FLAG.compareAndSet(false, true)) {
            FontStyle fontStyle = new FontStyle();
            fontStyle.setName(DEFAULT_FONT);
            fontStyle.setUrl("https://mtest.wstong.com/test/PingFang.ttc");
            fontStyle.setSize(30.0f);
            fontStyle.setStyle(0);
            FONT_MAP.put(DEFAULT_FONT, FontManage.loadFont(fontStyle));
            if (log.isDebugEnabled()) {
                log.debug("\u52a0\u8f7d\u9ed8\u8ba4\u5b57\u4f53\u5b8c\u6210\uff0c\u52a0\u8f7d\u5730\u5740\uff1a{}", (Object)fontStyle.getUrl());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Font loadFont(FontStyle fontStyle) {
        Font font;
        if (null == fontStyle.getName()) {
            fontStyle.setName(DEFAULT_FONT);
        }
        if ((font = FONT_MAP.get(fontStyle.getName())) == null) {
            try (InputStream inputStream = FileLoadUtil.load(fontStyle.getUrl(), true);){
                if (null == inputStream) {
                    Font font2 = null;
                    return font2;
                }
                System.setProperty("java.awt.headless", "true");
                font = Font.createFont(0, inputStream);
                log.info("\u5b57\u4f53[{}]\u52a0\u8f7d\u6210\u529f", (Object)fontStyle.getName());
            }
            catch (FontFormatException | IOException e) {
                log.info("\u5b57\u4f53[{}]\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)fontStyle.getName(), (Object)fontStyle.getUrl());
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (null == font) {
            log.error("\u4ecd\u7136\u65e0\u6cd5\u52a0\u8f7d\u5b57\u4f53\u6587\u4ef6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u914d\u7f6e\u4e86\u5bf9\u5e94\u7684\u5b57\u4f53\u6587\u4ef6");
            return null;
        }
        float pt = fontStyle.getSize() * 3.0f / 4.0f;
        return font.deriveFont(fontStyle.getStyle(), pt);
    }
}

