/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.cloud.ribbon;

import com.bxm.newidea.cloud.ribbon.RibbonFilterContext;
import com.bxm.newidea.cloud.ribbon.RibbonFilterContextHolder;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvDiscoveryEnabledRule
extends ZoneAvoidanceRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvDiscoveryEnabledRule.class);
    private boolean preEnv;

    public void setPreEnv(boolean preEnv) {
        this.preEnv = preEnv;
    }

    public Server choose(Object key) {
        Optional server;
        String ribbonVal;
        ILoadBalancer lb = this.getLoadBalancer();
        List allServers = lb.getAllServers();
        ArrayList<Server> matchedMetaServers = new ArrayList<Server>();
        List unmatchServers = Lists.newArrayList();
        if (this.preEnv) {
            ribbonVal = "env";
        } else {
            RibbonFilterContext context = RibbonFilterContextHolder.getCurrentContext();
            LOGGER.debug("contenxt:{}", (Object)context);
            Map<String, String> attributes = context.getAttributes();
            ribbonVal = attributes.get("env");
        }
        for (Server server2 : allServers) {
            if (!(server2 instanceof DiscoveryEnabledServer)) continue;
            DiscoveryEnabledServer discoveryEnabledServer = (DiscoveryEnabledServer)server2;
            Map metadata = discoveryEnabledServer.getInstanceInfo().getMetadata();
            String env = (String)metadata.get("env");
            if (StringUtils.isNotBlank((String)env) && "pre".equals(env)) {
                matchedMetaServers.add(server2);
                continue;
            }
            unmatchServers.add(server2);
        }
        LOGGER.info("key:{},allserver:{},matchServers:{},unmatchServer:{},ribbonVal:{},preEnv:{}", new Object[]{key, allServers.size(), matchedMetaServers.size(), unmatchServers.size(), ribbonVal, this.preEnv});
        if (StringUtils.isNotBlank((String)ribbonVal)) {
            if (!matchedMetaServers.isEmpty()) {
                server = this.getPredicate().chooseRoundRobinAfterFiltering(matchedMetaServers, key);
                if (server.isPresent()) {
                    LOGGER.debug("choose server: " + ((Server)server.get()).getId() + ",env:" + ribbonVal + ",key:" + key);
                    return (Server)server.get();
                }
                LOGGER.warn("\u8bf7\u6c42\u5934\u4fe1\u606f\u4e2d\u5305\u542b\u9884\u53d1\u952e\u503c\uff0c\u4f46\u662f\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u670d\u52a1\uff0c\u8bf7\u6c42key\uff1a" + key);
                return null;
            }
            LOGGER.warn("\u672a\u547d\u4e2d\u9884\u53d1\u670d\u52a1\uff0c\u76f4\u63a5\u4f7f\u7528\u5168\u90e8\u670d\u52a1\uff1a" + key);
            unmatchServers = allServers;
            LOGGER.debug("\u8bf7\u6c42\u5934\u4fe1\u606f\u4e2d\u5305\u542b\u9884\u53d1\u952e\u503c\uff0c\u4f46\u662f\u672a\u627e\u5230\u5bf9\u5e94\u914d\u7f6e\u7684\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u90e8\u7f72\u7684eureka metadata\uff0c\u8bf7\u6c42key\uff1a{},ribbonVal:{}", key, (Object)ribbonVal);
        } else if (unmatchServers.size() == 0) {
            unmatchServers = allServers;
        }
        server = this.getPredicate().chooseRoundRobinAfterFiltering(unmatchServers, key);
        if (server.isPresent()) {
            LOGGER.debug("choose server: " + ((Server)server.get()).getId() + ",key:" + key + ",ribbonVal:" + ribbonVal);
            return (Server)server.get();
        }
        return null;
    }
}

